/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tdeactionselector.h>
#include <tdeconfig.h>
#include <tdeapplication.h>
#include <kcombobox.h>
#include <tdelocale.h>

#include <tqframe.h>
#include <tqlayout.h>
#include <tqslider.h>
#include <tqcheckbox.h>
#include <tqstringlist.h>
#include <tqradiobutton.h>
 
#include "katapultconfigdlg.h"
#include "katapultsettings.h"
#include "katapultcatalog.h"
#include "katapultdisplay.h"

#include "confgeneral.h"
#include "confcatalogs.h"
#include "confdisplay.h"

KatapultConfigDlg::KatapultConfigDlg(KatapultSettings *settings)
 : KDialogBase(TreeList, "Configure", Ok|Cancel|Help, Ok)
{
	this->settings = settings;
	setTreeListAutoResize(true);

	// general settings	
	TQFrame *fConfGeneral = addPage(TQString("Katapult"), i18n("General Settings"));
	general = new ConfGeneral(fConfGeneral);
	(new TQVBoxLayout(fConfGeneral, 0, KDialog::spacingHint()))->addWidget(general);
	
	general->hideDelay->setValue(settings->hideDelay());
	general->autoExec->setChecked(settings->isAutoExecute());
	general->noResultsDelay->setValue(settings->noResultsDelay());
	general->systrayIcon->setChecked(settings->systrayIcon());
	switch(settings->noResultsAction()) {
		case KatapultSettings::NR_DoNothing:	general->nrDoNothing->setChecked(true);		break;
		case KatapultSettings::NR_HideDisplay:	general->nrHideDisplay->setChecked(true);	break;
		default:				general->nrClearQuery->setChecked(true);	break;
	}
	connect(general->nrDoNothing, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(nrDoNothingToggled(bool)));
	general->noResultsDelay->setEnabled(!general->nrDoNothing->isChecked());
	
	// catalog settings
	TQFrame *fConfCatalogs = addPage(i18n("Catalogs"), i18n("Enabled Catalogs"));
	catalogConf = new ConfCatalogs(fConfCatalogs);
	(new TQVBoxLayout(fConfCatalogs, 0, KDialog::spacingHint()))->addWidget(catalogConf);
	
	catalogConf->catalogs->selectedListBox()->insertStringList(settings->activeCatalogNames());
	catalogConf->catalogs->availableListBox()->insertStringList(settings->inactiveCatalogNames());
	
	catalogPages.setAutoDelete(true);
	TQDict<KatapultCatalog> catalogs;
	catalogs = settings->activeCatalogs();
	TQDictIterator<KatapultCatalog> it(catalogs);
	KatapultCatalog *catalog;
	while((catalog = it.current()) != 0)
	{
		TQString catalogName = it.currentKey();
		addCatalogPage(catalogName, catalog);
		++it;
	}
	
	// display settings
	TQFrame *fConfDisplay = addPage(i18n("Display"), i18n("Display"));
	display = new ConfDisplay(fConfDisplay);
	(new TQVBoxLayout(fConfDisplay, 0, KDialog::spacingHint()))->addWidget(display);
	new TQVBoxLayout((TQWidget *) display->displaySettings, 0, KDialog::spacingHint());
	
	TQStringList displays = settings->displayNames();
	display->displayName->insertStringList(displays);
	display->displayName->setCurrentItem(settings->displayNumber());
	displayConfig = 0;
	addDisplaySettings();
	
	unfoldTreeList(true);
	
	// connect signals	
	connect(catalogConf->catalogs, TQ_SIGNAL(added(TQListBoxItem *)), this, TQ_SLOT(activateCatalog(TQListBoxItem* )));
	connect(catalogConf->catalogs, TQ_SIGNAL(removed(TQListBoxItem *)), this, TQ_SLOT(deactivateCatalog(TQListBoxItem* )));
	connect(display->displayName, TQ_SIGNAL(activated(int)), this, TQ_SLOT(activateDisplay(int)));
	connect(this, TQ_SIGNAL(okClicked()), this, TQ_SLOT(saveSettings()));
}

KatapultConfigDlg::~KatapultConfigDlg()
{
}

void KatapultConfigDlg::nrDoNothingToggled(bool on)
{
	general->noResultsDelay->setEnabled(!on);
}

void KatapultConfigDlg::saveSettings()
{
	settings->setHideDelay(general->hideDelay->value());
	settings->setAutoExecute(general->autoExec->isChecked());
	settings->setNoResultsDelay(general->noResultsDelay->value());
	settings->setSystrayIcon(general->systrayIcon->isChecked());
	if (general->nrDoNothing->isChecked()) {
		settings->setNoResultsAction(KatapultSettings::NR_DoNothing);
	} else if (general->nrHideDisplay->isChecked()) {
		settings->setNoResultsAction(KatapultSettings::NR_HideDisplay);
	} else {
		settings->setNoResultsAction(KatapultSettings::NR_ClearQuery);
	}
}

void KatapultConfigDlg::activateCatalog(TQListBoxItem *i)
{
	settings->activateCatalog(i->text());
	KatapultCatalog *catalog = settings->catalog(i->text());
	if(catalog != 0)
		addCatalogPage(i->text(), catalog);
}

void KatapultConfigDlg::deactivateCatalog(TQListBoxItem *i)
{
	catalogPages.remove(i->text());
	settings->deactivateCatalog(i->text());
}

void KatapultConfigDlg::activateDisplay(int index)
{
	settings->setDisplayName(settings->displayIds()[index]);
	addDisplaySettings();
}

void KatapultConfigDlg::addCatalogPage(TQString name, KatapultCatalog *catalog)
{
	TQWidget *catalogConfig = catalog->configure();
	if(catalogConfig != 0)
	{
		TQStringList path;
		path << i18n("Catalogs") << name;
		TQFrame *fCatalog = addPage(path, name);
		catalogConfig->reparent(fCatalog, TQPoint(0, 0));
		(new TQVBoxLayout(fCatalog, 0, KDialog::spacingHint()))->addWidget(catalogConfig);
		catalogPages.insert(name, fCatalog);
	}
}

void KatapultConfigDlg::addDisplaySettings()
{
	if(displayConfig != 0)
	{
		delete displayConfig;
		displayConfig = 0;
	}
	displayConfig = settings->display()->configure();
	if(displayConfig != 0)
	{
		displayConfig->reparent((TQWidget *) display->displaySettings, TQPoint(0, 0));
		display->displaySettings->layout()->add(displayConfig);
		displayConfig->show();
	}
}

#include "katapultconfigdlg.moc"
