/***************************************************************************
                          kbswitchtrayicon.cpp  -  description
                             -------------------
    begin                : Wed Jul 4 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeversion.h>
 
#undef USE_BOLD_MENUITEM
 
#include "kbswitchtrayicon.h"
#include "xkeyboard.h"
#ifdef USE_BOLD_MENUITEM
  #include "boldmenuitem.h"
#endif  
#include <tdepopupmenu.h>
#include <kstandarddirs.h>
#include <tdelocale.h>
#include <kstdaction.h>
#include <tdeaction.h>
#include <tdeaboutapplication.h>
#include <tdeapplication.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <tdeversion.h>
#include <tqtooltip.h>
#include <tqstyle.h>
#include <tqpainter.h>

#ifdef USE_BOLD_MENUITEM
static TQColor getActiveTextColor(TDEPopupMenu *menu)
{
	int id = menu->insertItem("test text");
	TQMenuItem *item = menu->findItem(id);
	TQStyleOption styleopt = TQStyleOption(item);
	TQPainter painter(menu);
	TQColorGroup &cg = menu->colorGroup();
	TDEApplication::style().drawControl(TQStyle::CE_PopupMenuItem, &painter, menu,
	  menu->contentsRect(), cg, TQStyle::Style_Enabled | TQStyle::Style_Active,
	  styleopt);
	menu->removeItem(id);
	return painter.pen().color();  
}
#endif

KBSwitchTrayIcon::KBSwitchTrayIcon(KBConfig *conf){
  TQPixmap pix;
  TDEActionCollection *actions = new TDEActionCollection(this);

  m_kbconf = conf;
  //TQObject::connect(conf, TQ_SIGNAL(changed()), this, TQ_SLOT(updateMenuIcons()));
  TDEPopupMenu * menu = contextMenu();
  addLayoutItems(menu, false);
  TQObject::connect(menu, TQ_SIGNAL(activated(int)), this, TQ_SLOT(slotMenuActivated(int)));

  menu->insertSeparator();
  TDEAction *pref = KStdAction::preferences(this, TQ_SIGNAL(preferencesSelected()), actions);
  pref->plug(menu);
  TDEAction *help = KStdAction::help(this, TQ_SLOT(slotHelp()), actions);
  help->plug(menu);
  TDEAction *about = KStdAction::aboutApp(this, TQ_SLOT(slotAbout()), actions);
  about->plug(menu);

  /*TQString path = locate("icon", "hicolor/16x16/apps/locale.png");
  if (!path.isEmpty()) pix.load(path);*/
  pix = kapp->iconLoader()->loadIcon("locale", TDEIcon::Small);
  menu->changeTitle(menu->idAt(0), pix, i18n("Keyboard Switch"));
  setAlignment(TQt::AlignHCenter | TQt::AlignCenter);
}

KBSwitchTrayIcon::~KBSwitchTrayIcon(){
}

/** No descriptions */
void KBSwitchTrayIcon::slotMenuActivated(int id){
  if (id >= 0 && id < m_kbconf->groupCount()) emit groupSelected(id);
}

/** No descriptions */
void KBSwitchTrayIcon::setActiveGroup(int groupno){
  int i;
  TDEPopupMenu *menu = contextMenu();
  for (i = 0; i < m_kbconf->groupCount(); i++)
    menu->setItemChecked(i, false);
  menu->setItemChecked(groupno, true);
}

/** No descriptions */
void KBSwitchTrayIcon::setToggleGroups(int group1, int group2){
  int i;
  bool toggling;
  TDEPopupMenu *menu = contextMenu();

  for (i = 0; i < m_kbconf->groupCount(); i++) {
    toggling = (i == group1 || i == group2);
#ifdef USE_BOLD_MENUITEM
		TQMenuItem *item = menu->findItem(i);
		BoldMenuItem *bolditem = dynamic_cast<BoldMenuItem*>(item->custom());
		bolditem->setBold(toggling);
#else
    if (toggling)
      menu->changeItem(i, m_kbconf->getGroup(i)->getName() + "*");
    else menu->changeItem(i, m_kbconf->getGroup(i)->getName());
#endif
  }
}

/** No descriptions */
void KBSwitchTrayIcon::mouseReleaseEvent(TQMouseEvent *event){
  if (event->button() == LeftButton) {
    emit clicked();
  }
}

/** No descriptions */
void KBSwitchTrayIcon::slotAbout(){
  TDEAboutApplication about;
  about.exec();
}

/** No descriptions */
void KBSwitchTrayIcon::updateMenuIcons(){
  TDEPopupMenu *menu = contextMenu();
  for (int i = 0; i < m_kbconf->groupCount(); i++) {
    menu->changeItem(i, m_kbconf->getGroup(i)->getPixmap(), menu->text(i));
  }
}

/** No descriptions */
void KBSwitchTrayIcon::addLayoutItems(TDEPopupMenu *menu, bool clearOld) {
  KBGroup *group;
  int index;
#ifdef USE_BOLD_MENUITEM
  TQColor active_text_color = getActiveTextColor(menu);
#endif  

  if (clearOld)
    for (int i = 0; i < XKeyboard::MaxNumKbdGroups; i++)
      if ((index = menu->indexOf(i)) >= 0) menu->removeItemAt(index);

  for (int i = 0; i < m_kbconf->groupCount(); i++) {
    group = m_kbconf->getGroup(i);
#ifdef USE_BOLD_MENUITEM
    /* the work on BoldMenuItems suspended: see comments in boldmenuitem.h */
    menu->insertItem(group->getPixmap(),
      new BoldMenuItem(group->getName(), active_text_color, false), i);
#else    
    menu->insertItem(group->getPixmap(), group->getName(), i, i + 1);
#endif    
  }
}

/** No descriptions */
void KBSwitchTrayIcon::reconfigure(){
  addLayoutItems(contextMenu(), true);
}

/** Update the tray icon display for the given group */
void KBSwitchTrayIcon::updateTrayIcon(int groupno){
  const TQPixmap& pix = m_kbconf->getGroup(groupno)->getPixmap();
  setPixmap(pix);
  setActiveGroup(groupno);
  TQToolTip::remove(this);
  TQToolTip::add(this, m_kbconf->getGroup(groupno)->getName());
}

/** Update menu and tray icons after configuration has changed */
void KBSwitchTrayIcon::slotUpdateIcons(){
  updateTrayIcon(XKeyboard::self()->getGroupNo());
  updateMenuIcons();
}

/** Display help */
void KBSwitchTrayIcon::slotHelp(){
  kapp->invokeHelp();
}

#include "kbswitchtrayicon.moc"
