/***************************************************************************
 *	 Copyright (C) 2007 by Ken Werner									   *
 *	 ken.werner@web.de													   *
 *																		   *
 *	 This program is free software; you can redistribute it and/or modify  *
 *	 it under the terms of the GNU General Public License as published by  *
 *	 the Free Software Foundation; either version 2 of the License, or	   *
 *	 (at your option) any later version.								   *
 *																		   *
 *	 This program is distributed in the hope that it will be useful,	   *
 *	 but WITHOUT ANY WARRANTY; without even the implied warranty of		   *
 *	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		   *
 *	 GNU General Public License for more details.						   *
 *																		   *
 *	 You should have received a copy of the GNU General Public License	   *
 *	 along with this program; if not, write to the						   *
 *	 Free Software Foundation, Inc.,									   *
 *	 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.			   *
 ***************************************************************************/

#include "batterysrc.h"
#include <tdelocale.h>
#include <kdebug.h>

#ifdef HAVE_TDEWHLIB
#include <tdehardwaredevices.h>
#endif

BatterySrc::BatterySrc(TQWidget* inParent, TQString inUDI):
		LabelSource(inParent),
		mTrigger(this, 5000),
		mUDI(inUDI),
		mHardwareDevices(NULL){
#ifdef HAVE_TDEHWLIB
	mHardwareDevices = TDEGlobal::hardwareDevices();
	TDEGenericDevice* hwdevice = mHardwareDevices->findByUniqueID(inUDI);

	if (hwdevice->type() == TDEGenericDeviceType::Battery) {
		TDEBatteryDevice* bdevice = static_cast<TDEBatteryDevice*>(hwdevice);
		mID = bdevice->friendlyName();
	}
#else
	mID = TQString::null;
#endif
	mName = mID;
	mDescription = i18n("This source displays the current state of charge of your battery.");
}

BatterySrc::~BatterySrc(){
	//
}

std::list<Source*>BatterySrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
#ifdef HAVE_TDEHWLIB
	TDEHardwareDevices* hardwareDevices = TDEGlobal::hardwareDevices();
	TDEGenericHardwareList hwlist = hardwareDevices->listAllPhysicalDevices();
	TDEGenericDevice *hwdevice;
	for (hwdevice = hwlist.first(); hwdevice; hwdevice = hwlist.next()) {
		if (hwdevice->type() == TDEGenericDeviceType::Battery) {
			list.push_back(new BatterySrc(inParent, hwdevice->uniqueID()));
		}
	}
#endif
	return list;
}

TQString BatterySrc::fetchValue() {
	TQString s = "n/a";
#ifdef HAVE_TDEHWLIB
	if (mHardwareDevices != NULL) {
		TDEGenericDevice* hwdevice = mHardwareDevices->findByUniqueID(mUDI);
		if (hwdevice->type() != TDEGenericDeviceType::Battery) {
			return i18n("unknown");
		}
		TDEBatteryDevice* bdevice = static_cast<TDEBatteryDevice*>(hwdevice);
		s = TQString::number(bdevice->chargePercent()) + " %";
	}
#endif
	return s;
}
#include "batterysrc.moc"
