/***************************************************************************
 *   Copyright (C) 2006 by Valentine Sinitsyn                              *
 *   e_val@inbox.ru                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef CPUFREQDCONNECTION_H
#define CPUFREQDCONNECTION_H

#include <tqstring.h>
#include <stdint.h>
#include <unistd.h>
#include <sys/types.h>

/* Excerpt from cpufreqd_remote.h (cpufreqd-2.0.0)
 *
 * Copyright (C) 2005  Mattia Dongili <malattia@linux.it>
 *                     Hrvoje Zeba <hrvoje@boo.mi2.hr>
 *
 * Format:
 *	it is an uint32_t used as bitmask
 *	
 *	31-16     15-0 
 *	<command> <arguments>
 * 
 * The response may be longer than a single line and is 
 * terminated by the RESPONSE_END (see defines).
 */

#define CMD_UPDATE_STATE	1 /* no arguments */
#define CMD_SET_PROFILE		2 /* <profile index> */
#define CMD_LIST_PROFILES	3 /* no arguments */
#define CMD_SET_RULE		4 /* <rule index> */
#define CMD_LIST_RULES		5 /* no arguments */
#define CMD_SET_MODE		6 /* <mode> */

#define ARG_DYNAMIC		(1)
#define ARG_MANUAL		(2)

class CPUFreqdConnection{
	public:
		CPUFreqdConnection();
		~CPUFreqdConnection();

		bool open();
		ssize_t read(void *buf, size_t size);
		bool write(uint32_t cmd, uint32_t arg);
		void close();

		bool available() const;
		bool lookup();

	private:
		TQString m_socket;
		int m_fd;
};

#endif
