/***************************************************************************
    begin                : Feb 24 2007
    copyright            : 2007 by Holger Danielsson
    email                : holger.danielsson@versanet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KILEABBREVVIEW_H
#define KILEABBREVVIEW_H

#include <tqstring.h>
#include <tqlabel.h>
#include <tqpopupmenu.h>

#include <klineedit.h>
#include <tdelistbox.h>
#include <tdelistview.h>
#include <kdialogbase.h>

//////////////////// KlistView for abbreviations ////////////////////

class KileAbbrevView : public TDEListView  
{
  TQ_OBJECT
  

public:
	enum { ALVabbrev=0, ALVlocal=1, ALVexpansion=2 };
	enum { ALVnone=0, ALVadd=1, ALVedit=2, ALVdelete=3 };

	KileAbbrevView(TQWidget *parent=0, const char *name=0);
	~KileAbbrevView();

	void init(const TQStringList *globallist, const TQStringList *locallist);
	bool findAbbreviation(const TQString &abbrev);
	void saveLocalAbbreviation(const TQString &filename);

signals:
	void updateAbbrevList(const TQString &ds, const TQString &as);
	void sendText(const TQString &text);
 
private slots:
	void slotMouseButtonClicked(int button, TQListViewItem *item, const TQPoint &pos, int);
	void slotContextMenu(TDEListView *, TQListViewItem *item, const TQPoint &pos);
	void slotPopupAbbreviation(int id);

private:
	TQPopupMenu* m_popup;
	bool m_changes;

	void addAbbreviation(const TQString &abbrev, const TQString &expansion);
	void changeAbbreviation(TDEListViewItem *item,const TQString &abbrev, const TQString &expansion);
	void deleteAbbreviation(TDEListViewItem *item);

	void addWordlist(const TQStringList *wordlist, bool global);

};

//////////////////// add/edit dialog for abbreviations ////////////////////

class KileAbbrevInputDialog : public KDialogBase  
{
   TQ_OBJECT
  

public: 
	KileAbbrevInputDialog(KileAbbrevView *listview, TDEListViewItem *item, int mode, const char *name=0);
	~KileAbbrevInputDialog();

	void abbreviation(TQString &abbrev, TQString &expansion);

private:
	KileAbbrevView *m_listview;
	TDEListViewItem *m_abbrevItem;
	KLineEdit *m_leAbbrev;
	KLineEdit *m_leExpansion;

	int m_mode;
	TQString m_abbrev, m_expansion;

public slots:
	void slotOk();

private slots:
	void slotTextChanged(const TQString &text);

};

#endif
