/***************************************************************************
                          radiostation-config.cpp  -  description
                             -------------------
    begin                : Sa Aug 16 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqlabel.h>
#include <tqspinbox.h>
#include <tqlayout.h>
#include <tdelocale.h>

#include <math.h>

#include "include/radiostation-config.h"
#include "include/frequencyradiostation.h"


RadioStationConfig::RadioStationConfig(TQWidget *parent)
    : TQWidget (parent)
{

}

RadioStationConfig::~RadioStationConfig()
{
}


///////////////////////////////////////////////////////////////////////

UndefinedRadioStationConfig::UndefinedRadioStationConfig (TQWidget *parent)
    : RadioStationConfig(parent)
{
    new TQLabel (i18n("I don't know how to edit this station"), this);
}

UndefinedRadioStationConfig::~UndefinedRadioStationConfig()
{
}

void UndefinedRadioStationConfig::setStationData   (const RadioStation &/*rs*/)
{
}

void UndefinedRadioStationConfig::storeStationData (RadioStation &/*rs*/)
{
}


///////////////////////////////////////////////////////////////////////

FrequencyRadioStationConfig::FrequencyRadioStationConfig (TQWidget *parent)
    : RadioStationConfig(parent)
{
    TQHBoxLayout *hl = new TQHBoxLayout(this);
    TQVBoxLayout *vl = new TQVBoxLayout(hl);
    vl->addWidget (new TQLabel(i18n("Frequency:"), this));
    m_editFrequency = new TQSpinBox(20, 150000, 10, this);
    vl->addWidget (m_editFrequency);
    hl->addItem(new TQSpacerItem (10, 1, TQSizePolicy::Expanding, TQSizePolicy::Fixed));

    connect (m_editFrequency, TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(slotValueChanged(int)));
}

FrequencyRadioStationConfig::~FrequencyRadioStationConfig()
{
}

void FrequencyRadioStationConfig::setStationData   (const RadioStation &x)
{
    const FrequencyRadioStation *rs = dynamic_cast<const FrequencyRadioStation*>(&x);
    if (rs) {
        m_editFrequency->setValue((int)rint(rs->frequency() * 1000));
    }
}

void FrequencyRadioStationConfig::storeStationData (RadioStation &x)
{
    FrequencyRadioStation *rs = dynamic_cast<FrequencyRadioStation*>(&x);
    if (rs) {
        rs->setFrequency(0.001 * m_editFrequency->value());
    }
}

void FrequencyRadioStationConfig::slotValueChanged(int /*i*/)
{
    emit changed(this);
}


#include "radiostation-config.moc"
