/***************************************************************************
                          displaycfg_interfaces.cpp  -  description
                             -------------------
    begin                : Fr Aug 15 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "displaycfg_interfaces.h"

// IDisplayCfg

IF_IMPL_SENDER  (  IDisplayCfg::notifyDisplayColorsChanged(const TQColor &a, const TQColor &b, const TQColor &c),
                   noticeDisplayColorsChanged(a,b, c)                                          )

IF_IMPL_SENDER  (  IDisplayCfg::notifyDisplayFontChanged(const TQFont &f),
                   noticeDisplayFontChanged(f)                                          )

// IDisplayCfgClient

IF_IMPL_SENDER  (  IDisplayCfgClient::sendDisplayColors(const TQColor &a, const TQColor &b, const TQColor &c),
                   setDisplayColors(a,b, c)                                                    )

IF_IMPL_SENDER  (  IDisplayCfgClient::sendDisplayFont(const TQFont &f),
                   setDisplayFont(f)                                                           )

const TQColor default_display_active_color = TQColor(20, 244, 20);
IF_IMPL_QUERY   (  const TQColor &IDisplayCfgClient::queryDisplayActiveColor(),
                   getDisplayActiveColor(),
                   default_display_active_color                                               )

const TQColor default_display_inactive_color = TQColor(10, 117, 10).light(75);
IF_IMPL_QUERY   (  const TQColor &IDisplayCfgClient::queryDisplayInactiveColor(),
                   getDisplayInactiveColor(),
                   default_display_inactive_color                                     )

const TQColor default_display_bkgnd_color = TQColor(10, 117, 10);
IF_IMPL_QUERY   (  const TQColor &IDisplayCfgClient::queryDisplayBkgndColor(),
                   getDisplayBkgndColor(),
                   default_display_bkgnd_color                                               )

const TQFont default_display_font = TQFont("Helvetica");
IF_IMPL_QUERY   (  const TQFont &IDisplayCfgClient::queryDisplayFont(),
                   getDisplayFont(),
                   default_display_font                                                )


void IDisplayCfgClient::noticeConnectedI    (cmplInterface *, bool /*pointer_valid*/)
{
    noticeDisplayColorsChanged(queryDisplayActiveColor(), queryDisplayInactiveColor(), queryDisplayBkgndColor());
    noticeDisplayFontChanged(queryDisplayFont());
}


void IDisplayCfgClient::noticeDisconnectedI   (cmplInterface *, bool /*pointer_valid*/)
{
    noticeDisplayColorsChanged(queryDisplayActiveColor(), queryDisplayInactiveColor(), queryDisplayBkgndColor());
    noticeDisplayFontChanged(queryDisplayFont());
}

