/***************************************************************************
                          errorlog.h  -  description
                             -------------------
    begin                : Sa Sep 13 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_ERRORLOG_H
#define KRADIO_ERRORLOG_H

#include <kdialogbase.h>

#include "../../src/include/errorlog-interfaces.h"
#include "../../src/include/widgetplugins.h"


class TQTextEdit;
class ErrorLog : public KDialogBase,
                 public WidgetPluginBase,
                 public IErrorLog
{
TQ_OBJECT
  
public:
    ErrorLog(const TQString &name = TQString());
    ~ErrorLog();

    virtual TQString pluginClassName() const { return "ErrorLog"; }
    virtual const TQString &name() const { return PluginBase::name(); }
    virtual       TQString &name()       { return PluginBase::name(); }

    virtual bool connectI (Interface *);
    virtual bool disconnectI (Interface *);

// WidgetPluginBase

    virtual void   saveState (TDEConfig *) const;
    virtual void   restoreState (TDEConfig *);

public slots:
    virtual void     showOnOrgDesktop();
    virtual void     show();
    virtual void     hide();
    virtual void     toggleShown () { WidgetPluginBase::pToggleShown(); }

protected:
                  TQWidget *getWidget()       { return this; }
            const TQWidget *getWidget() const { return this; }

    virtual void showEvent(TQShowEvent *);
    virtual void hideEvent(TQHideEvent *);

    virtual ConfigPageInfo createConfigurationPage () { return ConfigPageInfo(); }
    virtual AboutPageInfo  createAboutPage ()         { return AboutPageInfo(); }

// IErrorLog

RECEIVERS:
    bool logError  (const TQString &);
    bool logWarning(const TQString &);
    bool logInfo   (const TQString &);
    bool logDebug  (const TQString &);

// KDialogBase

protected slots:

    void slotUser1();

protected:

    TQTextEdit  *m_teDebug,
               *m_teInfos,
               *m_teWarnings,
               *m_teErrors;

    bool        init_done;
};

#endif
