
#include "replaygainscanner.h"
#include "logger.h"
#include "combobutton.h"
#include "configuration.h"
#include "dirdialog.h"

#include <tqlayout.h>
#include <tqstringlist.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqtooltip.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <tdefiledialog.h>
#include <kpushbutton.h>
#include <kprogress.h>

// FIXME file name encoding !!!


ReplayGainScanner::ReplayGainScanner( TagEngine* _tagEngine, Config* _config, Logger* _logger, TQWidget *parent, const char *name, bool modal, WFlags f )
    : KDialog( parent, name, modal, f )
{
    tagEngine = _tagEngine;
    config = _config;
    logger = _logger;

    // create an icon loader object for loading icons
    TDEIconLoader* iconLoader = new TDEIconLoader();

    setCaption( i18n("Replay Gain Tool") );
    resize( 600, 400 );
    setIcon( iconLoader->loadIcon("soundkonverter_replaygain",TDEIcon::Small) );

    TQGridLayout* grid = new TQGridLayout( this, 4, 1, 11, 6 );

    TQHBoxLayout* filterBox = new TQHBoxLayout();
    grid->addLayout( filterBox, 0, 0 );

    cAdd = new ComboButton( this, "cAdd" );
    cAdd->insertItem( iconLoader->loadIcon("folder",TDEIcon::Small),i18n("Add Folder ...") );
    cAdd->insertItem( iconLoader->loadIcon("audio-x-generic",TDEIcon::Small),i18n("Add Files ...") );
    filterBox->addWidget( cAdd );
    connect( cAdd, TQ_SIGNAL(clicked(int)),
               this, TQ_SLOT(addClicked(int))
             );

    filterBox->addStretch();

    cForce = new TQCheckBox( i18n("Force recalculation"), this, "cForce" );
    TQToolTip::add( cForce, i18n("Recalculate Replay Gain tag for files that already have a Replay Gain tag set.") );
    filterBox->addWidget( cForce );

    /*TQLabel *lFilter=new TQLabel(i18n("Show:"),this,"lFilter");
    filterBox->addWidget(lFilter);

    cFilter=new TQComboBox(this,"cFilter");
    cFilter->insertItem(i18n("All"));
    cFilter->insertItem(i18n("With Replay Gain"));
    cFilter->insertItem(i18n("Without Replay Gain"));
    cFilter->insertItem(i18n("Unknown"));
    filterBox->addWidget(cFilter);*/

    lList = new ReplayGainFileList( tagEngine, config, logger, this, "lList" );
    grid->addWidget( lList, 1, 0 );
    connect( this, TQ_SIGNAL(addFile(const TQString&)),
               lList, TQ_SLOT(addFile(const TQString&))
             );
    connect( this, TQ_SIGNAL(addDir(const TQString&,const TQStringList&,bool)),
               lList, TQ_SLOT(addDir(const TQString&,const TQStringList&,bool))
             );
    connect( this, TQ_SIGNAL(calcAllReplayGain(bool)),
               lList, TQ_SLOT(calcAllReplayGain(bool))
             );
    connect( this, TQ_SIGNAL(removeAllReplayGain()),
               lList, TQ_SLOT(removeAllReplayGain())
             );
    connect( this, TQ_SIGNAL(cancelProcess()),
               lList, TQ_SLOT(cancelProcess())
             );
    connect( lList, TQ_SIGNAL(processStarted()),
               this, TQ_SLOT(processStarted())
             );
    connect( lList, TQ_SIGNAL(processStopped()),
               this, TQ_SLOT(processStopped())
             );
    connect( lList, TQ_SIGNAL(updateProgress(int,int)),
               this, TQ_SLOT(updateProgress(int,int))
             );

    TQHBoxLayout* progressBox = new TQHBoxLayout();
    grid->addLayout( progressBox, 2, 0 );

    pProgressBar = new KProgress( this, "pProgressBar" );
    progressBox->addWidget( pProgressBar );

    TQHBoxLayout* buttonBox = new TQHBoxLayout();
    grid->addLayout( buttonBox, 3, 0 );

    pTagVisible = new KPushButton( iconLoader->loadIcon("apply",TDEIcon::Small), i18n("Tag untagged"), this, "pTagVisible" );
    TQToolTip::add( pTagVisible, i18n("Calculate Replay Gain tag for all files in the file list without Replay Gain tag.") );
    buttonBox->addWidget( pTagVisible );
    connect( pTagVisible, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(calcReplayGainClicked())
             );

    pRemoveTag = new KPushButton( iconLoader->loadIcon("cancel",TDEIcon::Small), i18n("Untag tagged"), this, "pRemoveTag" );
    TQToolTip::add( pRemoveTag, i18n("Remove the Replay Gain tag from all files in the file list.") );
    buttonBox->addWidget( pRemoveTag );
    connect( pRemoveTag, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(removeReplayGainClicked())
             );

    pCancel = new KPushButton( iconLoader->loadIcon("cancel",TDEIcon::Small),i18n("Cancel"), this, "pCancel" );
    pCancel->hide();
    buttonBox->addWidget( pCancel );
    connect( pCancel, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(cancelClicked())
             );

    buttonBox->addStretch();

    pOk = new KPushButton( iconLoader->loadIcon("system-log-out",TDEIcon::Small), i18n("Close"), this, "pOk" );
    pOk->setFocus();
    buttonBox->addWidget( pOk );
    connect( pOk, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(accept())
             );

    // delete the icon loader object
    delete iconLoader;
}

ReplayGainScanner::~ReplayGainScanner()
{}

void ReplayGainScanner::addClicked( int index )
{
    if( index == 1 ) {
        showFileDialog();
    }
    else {
        showDirDialog();
    }
}

void ReplayGainScanner::showFileDialog()
{
    KFileDialog* dialog = new KFileDialog( ":file_open", config->replayGainFilter(), this, i18n("Choose files!").utf8().data(), true );
    dialog->setMode ( KFile::Files | KFile::ExistingOnly );
    if( dialog->exec() == KDialog::Accepted ) {
        TQStringList urls = dialog->selectedURLs().toStringList();
        for( TQStringList::Iterator it = urls.begin(); it != urls.end(); ++it ) {
            emit addFile( *it );
        }
    }
}

void ReplayGainScanner::showDirDialog()
{
//     TQString directory = KFileDialog::getExistingDirectory( ":file_open", this, i18n("Choose a directory!") );
//     if( directory != NULL )
//     {
//         emit addDir( directory );
//     }

    DirDialog *dialog = new DirDialog( config, DirDialog::ReplayGain, this, "DirDialog" );

    TQ_CHECK_PTR( dialog );

    if( dialog->exec() ) {
        emit addDir( dialog->directory, dialog->selectedFileTypes, dialog->recursive );
    }

    delete dialog;
}

void ReplayGainScanner::addFiles( TQStringList files )
{
    for( TQStringList::Iterator it = files.begin(); it != files.end(); ++it ) {
        emit addFile( *it );
    }
}

void ReplayGainScanner::calcReplayGainClicked()
{
    emit calcAllReplayGain( cForce->isChecked() );
}

void ReplayGainScanner::removeReplayGainClicked()
{
    emit removeAllReplayGain();
}

void ReplayGainScanner::cancelClicked()
{
    emit cancelProcess();
}

void ReplayGainScanner::processStarted()
{
    pTagVisible->hide();
    pRemoveTag->hide();
    pCancel->show();
}

void ReplayGainScanner::processStopped()
{
    pTagVisible->show();
    pRemoveTag->show();
    pCancel->hide();
    pProgressBar->setProgress( 100 );
    pProgressBar->setTotalSteps( 100 );
    setCaption( i18n("Finished") + " - " + i18n("Replay Gain Tool") );
}

void ReplayGainScanner::updateProgress( int progress, int totalSteps )
{
/*    pProgressBar->setProgress( int(processedTime) + percent * int(timeCount) / 100 );
    pProgressBar->setTotalSteps( int(time) );*/
    pProgressBar->setProgress( progress );
    pProgressBar->setTotalSteps( totalSteps );
    float fPercent;
    if( pProgressBar->totalSteps() > 0 ) fPercent = pProgressBar->progress() * 100 / pProgressBar->totalSteps();
    else fPercent = 0;

    TQString percent;
    percent.sprintf( "%i%%", (int)fPercent );
    setCaption( percent + " - " + i18n("Replay Gain Tool") );
}

#include "replaygainscanner.moc"
