/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_PERCUSSIONPITCHRULER_H_
#define _RG_PERCUSSIONPITCHRULER_H_

#include "PitchRuler.h"
#include <tqsize.h>


class TQWidget;
class TQPaintEvent;
class TQMouseEvent;
class TQFontMetrics;
class TQFont;
class TQEvent;


namespace Rosegarden
{

class MidiKeyMapping;


class PercussionPitchRuler : public PitchRuler
{
    TQ_OBJECT
  
public:
    PercussionPitchRuler(TQWidget *parent,
                         const MidiKeyMapping *mapping,
                         int lineSpacing);

    virtual TQSize sizeHint() const;
    virtual TQSize minimumSizeHint() const;

    void drawHoverNote(int evPitch);

signals:
    void keyPressed(unsigned int y, bool repeating);
    void keySelected(unsigned int y, bool repeating);
    void hoveredOverKeyChanged(unsigned int y);

protected:
    virtual void paintEvent(TQPaintEvent*);
    virtual void mouseMoveEvent(TQMouseEvent*);
    virtual void mousePressEvent(TQMouseEvent*);
    virtual void mouseReleaseEvent(TQMouseEvent*);
    virtual void enterEvent(TQEvent *);
    virtual void leaveEvent(TQEvent *);

    const MidiKeyMapping *m_mapping;

    int                       m_width;
    int                       m_lineSpacing;

    bool                      m_mouseDown;
    bool                      m_selecting;

    int                       m_lastHoverHighlight;

    TQFont                    *m_font;
    TQFontMetrics             *m_fontMetrics;
};



}

#endif
