/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "MatrixParameterBox.h"

#include "base/Instrument.h"
#include "base/BasicQuantizer.h"
#include "base/Selection.h"
#include "document/RosegardenGUIDoc.h"
#include "gui/editors/parameters/InstrumentParameterBox.h"
#include <kcombobox.h>
#include <tqfont.h>
#include <tqfontmetrics.h>
#include <tqframe.h>
#include <tqlayout.h>
#include <tqwidget.h>


namespace Rosegarden
{

MatrixParameterBox::MatrixParameterBox(RosegardenGUIDoc *doc,
                                       TQWidget *parent, const char* name):
        TQFrame(parent, name),
        m_quantizations(BasicQuantizer::getStandardQuantizations()),
        m_doc(doc)
{
    setFrameStyle(NoFrame);
    initBox();
}

MatrixParameterBox::~MatrixParameterBox()
{}

void
MatrixParameterBox::initBox()
{
    TQFont boldFont;
    boldFont.setPointSize(int(boldFont.pointSize() * 9.5 / 10.0 + 0.5));
    boldFont.setBold(true);

    TQFont plainFont;
    plainFont.setPointSize(plainFont.pointSize() * 9 / 10);
    TQFont font = plainFont;

    TQFontMetrics fontMetrics(font);
    // magic numbers: 13 is the height of the menu pixmaps, 10 is just 10
    //int comboHeight = std::max(fontMetrics.height(), 13) + 10;

    TQGridLayout *gridLayout = new TQGridLayout(this, 20, 3, 8, 1);

    m_instrumentParameterBox = new InstrumentParameterBox(m_doc, this);
    gridLayout->addMultiCellWidget(m_instrumentParameterBox, 0, 7, 0, 2);

}

void
MatrixParameterBox::setSelection(EventSelection *selection)
{
    if (!selection)
        return ;

    EventSelection::eventcontainer::iterator
    it = selection->getSegmentEvents().begin();

for (; it != selection->getSegmentEvents().end(); it++) {}

}

void
MatrixParameterBox::useInstrument(Instrument *instrument)
{
    m_instrumentParameterBox->useInstrument(instrument);
}

}
#include "MatrixParameterBox.moc"
