/***************************************************************************
 *   Copyright (C) 2005 by Jean-Michel Petit                               *
 *   jm_petit@laposte.net                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "k9backupdlg.h"
#include "ac.h"
#include <tqtimer.h>
#include <tqdatetime.h>
#include <tqapplication.h>
#include <tqprogressbar.h>
#include <tqlabel.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <kguiitem.h>
#include <tqlabel.h>
#include <tqpainter.h>
#include <tqlayout.h>
#include "k9drawimage.h"

k9BackupDlg::k9BackupDlg(TQWidget* parent, const char* name, bool modal, WFlags fl)
        : backupDlg(parent,name, modal,fl) {
    Abort=false;
    timer = new TQTimer( this );
    time = new TQTime(0,0);
    time->start();
    connect( timer, TQ_SIGNAL(timeout()), this, TQ_SLOT(timerDone()) );
    timer->start(500, 0 );
    bAbort->setIconSet(KStdGuiItem::cancel().iconSet());
    bPlay->setIconSet(SmallIcon("media-playback-start"));
    totalCopied=0;
    m_progressTotal=0;
    m_progressLabel="";
    m_totalSteps=0;
    m_factor="";
    m_progress=0;
    connect(&m_decoder, TQ_SIGNAL(pixmapReady(TQImage *)), this, TQ_SLOT(drawPixmap(TQImage *)));
    m_stop=false;
    m_playmovie=true;
    m_cpt=0;
    m_wimage=new k9DrawImage(image,0);
    TQGridLayout *l=new TQGridLayout(image,1,1);
    l->addWidget(m_wimage,0,0);
     m_data=NULL;
     m_dataSize=0;
}

void k9BackupDlg::drawPixmap(TQImage *_image) {
	m_count++;
	if (m_count ==4) {
  
        m_wimage->setImage(*_image);

	m_stop=true;
	}
}

void k9BackupDlg::bPlayToggled( bool state) {
	m_playmovie=bPlay->isOn();
}

 void k9BackupDlg::playMovie(uchar *_data,uint32_t _size) {
	if (!m_playmovie || m_dataSize)
		return;
	m_count=0;
	m_dataSize=_size;
	m_data=(uchar*)malloc(_size);
	tc_memcpy(m_data,_data,_size);	
}


k9BackupDlg::~k9BackupDlg() {
    delete timer;
    delete time;
    if  (m_data)
        free(m_data);
}

void k9BackupDlg::update(){
    lblStep->setText(m_progressLabel);
    pbTotal->setProgress(m_progressTotal);
    pbStep->setTotalSteps(m_totalSteps);
    lblFactor->setText(m_factor);
    pbStep->setProgress(m_progress);

    if (m_data) {
	if (m_stop)
		m_decoder.start();
	m_stop=false;
	for (uint32_t i=0;i<m_dataSize-2048;i+=2048) {
		if (m_stop) {
			m_decoder.stop();
			break;
		}
		m_decoder.decode(m_data +i ,m_data+i+2048,0);
	}
	free(m_data);
	m_data=NULL;
	m_dataSize=0;
	
	m_playmovie=false;
     }

}

void k9BackupDlg::timerDone() {
   m_cpt++;
   if (m_cpt==10) {
	m_cpt=0;
	m_playmovie=bPlay->isOn();
   }
    TQTime time2(0,0);
    time2=time2.addMSecs(time->elapsed());
    TQString remain("--:--:--");
    if (m_progressTotal>0) {
	TQTime time3(0,0);
	time3=time3.addMSecs((time->elapsed()/m_progressTotal)*pbTotal->totalSteps());
	remain=time3.toString("hh:mm:ss");
    }

    lblTime->setText(time2.toString("hh:mm:ss") +" / " +remain);
    update();
}

void k9BackupDlg::setTotalSteps(uint32_t _totalSteps) {
    m_totalSteps=_totalSteps;
}

void k9BackupDlg::setProgress(uint32_t _position) {
    m_progress=_position;
}

void k9BackupDlg::setTotalMax(uint32_t _max) {
    pbTotal->setTotalSteps(_max);
}

void k9BackupDlg::setProgressTotal(uint32_t _position) {
   totalCopied+=_position;
   uint64_t total=totalCopied*2048;
   total/=(1024*1024);
   m_progressTotal=total;

}

void k9BackupDlg::setProgressLabel(TQString _text) {
	m_progressLabel=_text;
	update();
}

bool k9BackupDlg::getAbort() {
    return Abort;
}

void k9BackupDlg::bAbortClick() {
    Abort=true;
    reject();

}

void k9BackupDlg::setFactor(TQString _factor) {
  m_factor=_factor;
}
/*$SPECIALIZATION$*/


#include "k9backupdlg.moc"
