/***************************************************************************
*   Copyright (C) 2005 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef INGLISTVIEWITEM_H
#define INGLISTVIEWITEM_H

#include "tqlistview.h"

#include "datablocks/ingredient.h"

#define INGGRPLISTVIEWITEM_RTTI 1003
#define INGLISTVIEWITEM_RTTI 1004
#define INGSUBLISTVIEWITEM_RTTI 1009

class IngListViewItem : public TQListViewItem
{
public:
	IngListViewItem( TQListView* qlv, const Ingredient &i );
	IngListViewItem( TQListView* qlv, TQListViewItem *after, const Ingredient &i );
	IngListViewItem( TQListViewItem* qli, TQListViewItem *after, const Ingredient &i );

	int rtti() const;

	Ingredient ingredient() const;

	void setAmount( double amount, double amount_offset );
	void setUnit( const Unit &unit );
	void setPrepMethod( const TQString &prepMethod );

protected:
	Ingredient m_ing;
	TQString amount_str;

public:
	virtual TQString text( int column ) const;
	virtual void setText( int column, const TQString &text );

private:
	void init( const Ingredient &i );
};


class IngSubListViewItem : public IngListViewItem
{
public:
	IngSubListViewItem( TQListViewItem* qli, const Ingredient &i );

	virtual TQString text( int column ) const;
	virtual void setText( int column, const TQString &text );
	virtual int rtti() const;
};


class IngGrpListViewItem : public TQListViewItem
{
public:
	IngGrpListViewItem( TQListView* qlv, TQListViewItem *after, const TQString &group, int id );

	int rtti() const;

	TQString group() const;
	int id() const;

	virtual TQString text( int column ) const;
	virtual void setText( int column, const TQString &text );

protected:
	TQString m_group;
	int m_id;

private:
	void init( const TQString &group, int id );
};

#endif
