/***************************************************************************
*   Copyright (C) 2004 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef AUTHORLISTVIEW_H
#define AUTHORLISTVIEW_H

#include "dblistviewbase.h"
#include "datablocks/element.h"

class RecipeDB;
class TDEPopupMenu;

class AuthorCheckListView;

class AuthorCheckListItem: public TQCheckListItem
{
public:
	AuthorCheckListItem( AuthorCheckListView* qlv, const Element &author );
	AuthorCheckListItem( AuthorCheckListView* qlv, TQListViewItem *after, const Element &author );

	Element author() const;

	virtual TQString text( int column ) const;

protected:
	virtual void stateChange( bool on );

private:
	Element authorStored;
	AuthorCheckListView *m_listview;
};


class AuthorListView : public DBListViewBase
{
	TQ_OBJECT

public:
	AuthorListView( TQWidget *parent, RecipeDB *db );

protected slots:
	void checkCreateAuthor( const Element &el );
	virtual void createAuthor( const Element & ) = 0;
	virtual void removeAuthor( int ) = 0;
	virtual void load( int curr_limit, int curr_offset );

protected:
	virtual void init();
};

class StdAuthorListView : public AuthorListView
{
	TQ_OBJECT

public:
	StdAuthorListView( TQWidget *parent, RecipeDB *db, bool editable = false );

protected:
	virtual void createAuthor( const Element & );
	virtual void removeAuthor( int );

private slots:
	void showPopup( TDEListView *, TQListViewItem *, const TQPoint & );

	void createNew();
	void remove
		();
	void rename();

	void modAuthor( TQListViewItem* i );
	void saveAuthor( TQListViewItem* i );

private:
	bool checkBounds( const TQString &name );

	TDEPopupMenu *kpop;
};


class AuthorCheckListView : public AuthorListView
{
public:
	AuthorCheckListView( TQWidget *parent, RecipeDB *db );

	virtual void stateChange(AuthorCheckListItem *,bool);

	TQValueList<Element> selections() const{ return m_selections; }

protected:
	virtual void createAuthor( const Element &ing );
	virtual void removeAuthor( int );

	virtual void load( int limit, int offset );

private:
	TQValueList<Element> m_selections;
};

#endif //AUTHORLISTVIEW_H
