/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CISCOCERTIFICATEENROLLMENT_H
#define CISCOCERTIFICATEENROLLMENT_H

#include <kdialogbase.h>
#include "ciscocertificateenrollmentbase.h"
#include "ciscocertificateenrollmentfinishwidgetbase.h"
#include "ciscocertificateenrollmentdatadialog.h"
#include <tqprocess.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <kdialogbase.h>
#include <kprogress.h>
#include <tqwizard.h>
#include <tqtimer.h>
#include "kvpncconfig.h"

/**
	@author Christoph Thielecke <crissi99@gmx.de>
*/
class CiscoCertificateEnrollment : public TQWizard
{
	TQ_OBJECT
  
	public:
		CiscoCertificateEnrollment ( TQWidget *parent, const char* caption, KVpncConfig *GlobalConfig );
		~CiscoCertificateEnrollment();
		TQProcess *EnrollmentProcess;
		TQProcess *DeleteProcess;
		KVpncConfig *GlobalConfig;
		bool done;
		bool finished;
		bool valuesOk;
		TQStringList *env;


	public slots:
		void accept();
		void canAccept();
		void enrollmentToggled(bool);
		void setupPages();
		void showPage( TQWidget* page );
		void next ();
		void back();
		void reject();
		void readFromStdout();
		void readFromStderr();
		void readFromStdout_cancel();
		void readFromStderr_cancel();
		void checkProgress();
		void enrollmentProcessFinished();
		void cancelProcessFinished();


	public:
		CiscoCertificateEnrollmentBase *selectionpage;
		CiscoCertificateEnrollmentDataDialogBase *datapage;
		CiscoCertificateEnrollmentFinishWidgetBase *finishpage;
		TQWidget* currentpage; // pointer to current page
		TQWidget* previouspage; //< pointer to previous page
		KProgressDialog *ProgressDlg;

	public:
		TQString type;
		TQString successmsg;
		int success;
		TQString CA;
		TQString CaUrl;
		TQString ChallengePassword;
		TQString CaDomain;
		TQString FileEncoding;
		TQString FilenameURL;
		TQString Ip;
		TQString State;
		TQString Department;
		TQString Company;
		TQString Domain;
		TQString Name;
		TQString Email;
		TQString Country;

	private:
		TQTimer CheckEnrollmentTimer;

};

#endif
