/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include <tdepopupmenu.h>
#include <tdelocale.h>
#include <twin.h>

#include "widgets/systemtray.h"
#include "widgets/balloon.h"
#include "mainwindow.h"
#include "mainactions.h"
#include "kftpbookmarks.h"
#include "kftpqueue.h"
#include "misc.h"
#include "misc/kftpconfig.h"

using namespace KFTPGrabberBase;

namespace KFTPWidgets {

SystemTray *SystemTray::m_self = 0L;

SystemTray::SystemTray(MainWindow *parent)
  : KSystemTray(parent),
    m_balloon(0),
    m_actions(parent->getActions())
{
  m_self = this;
  
  // Set icon and show it
  setPixmap(loadToolbarPixmap("kftpgrabber"));
  
  if (KFTPCore::Config::showSystrayIcon())
    show();

  // Add some actions
  m_bookmarkMenu = new TDEActionMenu(i18n("Bookmarks"));
  slotUpdateBookmarks();

  // Let our bookmarks be up to date
  connect(KFTPBookmarks::Manager::self(), TQ_SIGNAL(update()), this, TQ_SLOT(slotUpdateBookmarks()));
  
  m_actions->m_fileConnectAction->plug(contextMenu(), 1);
  m_bookmarkMenu->plug(contextMenu(), 1);
  
  // Ensure that we actually quit
  connect(this, TQ_SIGNAL(quitSelected()), this, TQ_SLOT(slotQuitSelected()));
}

SystemTray::~SystemTray()
{
  delete m_bookmarkMenu;
}

void SystemTray::slotQuitSelected()
{
  m_actions->m_closeApp = true;
}

void SystemTray::slotUpdateBookmarks()
{
  // Re-create the bookmarks menu
  m_bookmarkMenu->popupMenu()->clear();
  KFTPBookmarks::Manager::self()->guiPopulateBookmarksMenu(m_bookmarkMenu, TQDomNode(), false);
}

void SystemTray::showBalloon(const TQString &text)
{
  // Create a little modified Kopete balloon
  if (m_balloon) {
    m_balloon->hide();
    delete m_balloon;
  }
  
  m_balloon = new Balloon("<qt><nobr><b>KFTPGrabber</b><br>" + text + "</nobr></qt>", "application-vnd.tde.info");
  m_balloon->setAnchor(mapToGlobal(pos()));
  m_balloon->show();
  KWin::setOnAllDesktops(m_balloon->winId() , true);

  // Hide the balloon after 5 sec
  TQTimer::singleShot(5000, this, TQ_SLOT(slotHideBalloon()));
}

void SystemTray::slotHideBalloon()
{
  m_balloon->hide();
}

}

#include "systemtray.moc"
