/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef MAINACTIONS_H
#define MAINACTIONS_H

#include <tqobject.h>
#include <tdeaction.h>

class MainWindow;
class TDEMainWindow;

namespace KFTPWidgets {
  class SystemTray;
  class ConfigDialog;
}

/**
 * This class contains the actions that are used in the main window,
 * it's toolbars and in the menu bar.
 *
 * @author Jernej Kos
 */
class MainActions : public TQObject
{
TQ_OBJECT
friend class MainWindow;
friend class KFTPWidgets::SystemTray;
public:
    /**
     * Class constructor.
     *
     * @param parent The main window instance
     */
    MainActions(MainWindow *parent);
private:
    // File menu
    TDEAction *m_fileConnectAction;
    TDEActionMenu *m_newSessionAction;
    
    // Edit menu
    TDEAction *m_renameAction;
    TDEAction *m_deleteAction;
    TDEAction *m_propsAction;
    TDEAction *m_shredAction;
    
    TDEAction *m_copyAction;
    TDEAction *m_pasteAction;
    
    TDEActionMenu *m_filterActions;
    TDEAction *m_alwaysSkipAction;
    TDEAction *m_topPriorityAction;
    TDEAction *m_lowPriorityAction;

    // Other
    TDEActionMenu *m_transModeAction;
    TDERadioAction *m_modeAscii;
    TDERadioAction *m_modeBinary;
    TDERadioAction *m_modeAuto;

    KFTPWidgets::ConfigDialog *m_configDialog;
    TDEActionCollection *actionCollection();
    TDEMainWindow *mainWidget();
    
    bool m_closeApp;
public slots:
    void slotFileQuit();
    
    void slotNewSessionLeft();
    void slotNewSessionRight();

    void slotConfigureToolbars();
    void slotKeyBindings();
    void slotSettingsSave();
    void slotSettingsConfig();
    
    void slotModeAscii();
    void slotModeBinary();
    void slotModeAuto();
};

#endif
