/***************************************************************************
 *   Copyright (C) 2003-2004 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "cnitem.h"
#include "cnitemgroup.h"
#include "itemeditor.h"
#include "orientationwidget.h"
#include "propertieslistview.h"

#include <tdelocale.h>
#include <kstandarddirs.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqwhatsthis.h>

#include <assert.h>

ItemEditor * ItemEditor::m_pSelf = 0l;

ItemEditor * ItemEditor::self( KateMDI::ToolView * parent )
{
	if (!m_pSelf)
	{
		assert(parent);
		m_pSelf = new ItemEditor(parent);
	}
	return m_pSelf;
}


ItemEditor::ItemEditor( KateMDI::ToolView * parent )
	: TQWidget( (TQWidget*)parent, "Item Editor" )
{
	TQWhatsThis::add( this, i18n("This allows editing of advanced properties of the selected item(s). Right click on the picture of the item to set the orientation.") );
	
	TQVBoxLayout *vlayout = new TQVBoxLayout( this, 0, 6 );

	m_nameLbl = new TQLabel( this, "" );
	vlayout->addWidget(m_nameLbl);
	vlayout->addSpacing(8);

	propList = new PropertiesListView(this);
	vlayout->addWidget(propList);
	TQWhatsThis::add(propList,i18n("<qt>Shows properties associated with the currently selected item(s).<p>Select a property to change its value. If multiple items are selected with different values then the property will appear greyed out, use ""Merge Properties"" to make them the same.<p>Select ""Defaults to set all properties to their default values""")); 
	
	TQHBoxLayout *h1Layout = new TQHBoxLayout( vlayout, 4 );
	TQSpacerItem *spacer1 = new TQSpacerItem( 1, 1 );
	h1Layout->addItem(spacer1);
	
	m_defaultsBtn = new TQPushButton( i18n("Defaults"), this);
	m_defaultsBtn->setEnabled(false);
	connect(m_defaultsBtn,TQ_SIGNAL(clicked()),propList,TQ_SLOT(slotSetDefaults()));
	h1Layout->addWidget(m_defaultsBtn);
	
	m_mergeBtn = new TQPushButton( i18n("Merge properties"), this );
	m_mergeBtn->setEnabled(false);
	connect(m_mergeBtn,TQ_SIGNAL(clicked()),this,TQ_SLOT(mergeProperties()));
	h1Layout->addWidget(m_mergeBtn);
	
	// TQt::Orientation widget stuff
	TQHBoxLayout *h2Layout = new TQHBoxLayout( vlayout, 6 );
	TQSpacerItem *spacer2 = new TQSpacerItem( 1, 1 );
	h2Layout->addItem(spacer2);
	m_orientationWidget = new OrientationWidget(this);
	h2Layout->addWidget(m_orientationWidget);
	TQWhatsThis::add(m_orientationWidget,i18n("Change the orientation of the selected item by selecting the appropriate button"));
	TQSpacerItem *spacer3 = new TQSpacerItem( 1, 1 );
	h2Layout->addItem(spacer3);
	
	slotClear();
}


ItemEditor::~ItemEditor()
{
}


void ItemEditor::mergeProperties()
{
	propList->slotMergeProperties();
	m_mergeBtn->setEnabled(false);
}


void ItemEditor::slotClear()
{
	propList->slotClear();
	m_orientationWidget->slotClear();
	m_defaultsBtn->setEnabled(false);
	m_mergeBtn->setEnabled(false);
	updateNameLabel(0l);
}


void ItemEditor::slotMultipleSelected()
{
	slotClear();
	m_nameLbl->setText( i18n("<h2>Multiple Items</h2>") );
}


void ItemEditor::slotUpdate( ItemGroup *itemGroup )
{
	if (!itemGroup) {
		slotClear();
		return;
	}
	
	updateMergeDefaults(itemGroup);
	propList->slotCreate(itemGroup);
	updateNameLabel(itemGroup->activeItem());
}


void ItemEditor::updateMergeDefaults( ItemGroup *itemGroup )
{
	if (!itemGroup)
	{
		m_defaultsBtn->setEnabled(false);
		m_mergeBtn->setEnabled(false);
		return;
	}
	
	m_mergeBtn->setEnabled( !itemGroup->itemsHaveSameData() );
	m_defaultsBtn->setEnabled( !itemGroup->itemsHaveDefaultData() );
	propList->slotUpdate(itemGroup);
}


void ItemEditor::slotUpdate( CNItem *item )
{
	m_orientationWidget->slotUpdate(item);
}


void ItemEditor::updateNameLabel( Item *item )
{
	if (item) {
		m_nameLbl->setText( "<h2>" + item->name() + "</h2>" );
	} else {
		m_nameLbl->setText( i18n("<h2>No Item Selected</h2>") );
	}
}


#include "itemeditor.moc"
