// A Qt to C# binding generator.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

using System;
using System.IO;
using System.Xml;
using System.Collections;

namespace QtCSharp {

	public class ParseAPI {

		XmlTextReader xtr;
		ArrayList qtypes;

		public ParseAPI (string xmlfile)
		{
			xtr = new XmlTextReader (xmlfile);
			qtypes = new ArrayList ();
			Parse ();
		}

		public ArrayList TQTypes
		{
			get {return qtypes;}
		}

		public void Parse ()
		{
			Hashtable typehash = new Hashtable();
			while(xtr.Read ()) {
				if (xtr.NodeType != XmlNodeType.EndElement) {
					switch(xtr.Name) {
						case "qtype":
								TQType t = AddTQType ();
								typehash[t.Name] = t;
							continue;
						default:
							continue;
					}
				}
			}

			foreach (TQType t in qtypes) {
				t.IsTQObject = IsTQObject(t, typehash);
			}
		}

		public TQType AddTQType ()
		{
			Parser parser = new Parser (xtr.ReadOuterXml ());
			TQType type = parser.GetTQType ();
			qtypes.Add (type);
			return type;
		}

		private static bool IsTQObject(TQType t, Hashtable typehash)
		{
			if (t.IsInterface) return false;
			if (t.Name == "TQObject") return true;

			foreach (TQAncestor a in t.TQAncestors) {
				TQType at = (TQType)typehash[a.Name];
				if (at == null)
					continue;
				else if (at.Name == "TQObject")
					return true;
				else if (IsTQObject(at, typehash))
					return true;
			}

			return false;
		}
	}
}
