#ifndef PMENUDATA_H
#define PMENUDATA_H

class PMenuData;

#include <tqobject.h>
#include <tqmenudata.h>
#include "pmessage.h"
#include "pframe.h"
#include "pobject.h"
#include "controller.h"

/**
 * Little helper class here gives us access to needed info inside
 * TQMenuData
 */

class PMenuDataHelper : public TQMenuData
{
public:
  PMenuDataHelper(TQMenuData &qmd) {
    memcpy(this, &qmd, sizeof(TQMenuData));
  }
  int active() {
    return TQMenuData::actItem;
  }
  int actItem;
};

/**
 * We're subclased off TQMenuData so we can access it's internal proteted vars
 * We do not initialize NOR create it!!!!
 */

class PMenuData :  public PObject
{
  TQ_OBJECT
  
public:
  PMenuData (PObject *_child);
  virtual ~PMenuData ();

  virtual void messageHandler(int fd, PukeMessage *pm);
  virtual bool menuMessageHandler(int fd, PukeMessage *pm);

//  virtual void setWidget(TQMenuData *_qmd);
 // virtual TQMenuData *widget();

  virtual int activeItem()
    {
      return PMenuDataHelper(*((TQMenuData *) child->widget())).active();
    }

 private:
   PObject *child;
};

#endif
