
#ifndef dockservercontroller_included
#define dockservercontroller_included

#include <ksystemtray.h>
#include <tqdict.h>
#include <tqstring.h>
#include <tqdatetime.h>
#include <tqpixmap.h>
#include <tqstringlist.h>

class TQPopupMenu;
class TQWidget;
class servercontroller;
class TQMouseEvent;
class TDEPopupMenu;
class TQTimer;

class dscNickInfo
{
public:
    dscNickInfo(TQString nick, TQString server);
    ~dscNickInfo();

    enum status {
	isOnline,
        isOffline
    };

    TQString nick() { return m_nick; }
    TQString server() { return m_server; }

    void setOnline() { m_status = isOnline; m_online = TQTime::currentTime(); }
    const TQTime &online() { return m_online; }

    void setOffline() { m_status = isOffline; m_offline = TQTime::currentTime(); }
    const TQTime offline() { return m_offline; }

    void setStatus(enum status stat) { m_status = stat; }
    enum status status() { return m_status; }

private:
    TQString m_nick;
    TQString m_server;
    enum status m_status;
    TQTime m_online;
    TQTime m_offline;

};

class dockServerController : public KSystemTray
{
  TQ_OBJECT
  
public:
  dockServerController(servercontroller *_sc, TQWidget *parent = 0x0, const char *_name = 0x0);
  ~dockServerController();

  void startBlink(const TQString& reason = TQString(), const TQString& text = TQString());
  void stopBlink(const TQString& reason = TQString(), bool clear = false);

  void nickOnline(TQString server, TQString nick);
  void nickOffline(TQString server, TQString nick);

  void serverOpen(TQString server);
  void serverClose(TQString server);

protected:
    void mousePressEvent( TQMouseEvent *);
    virtual void showPopupMenu( TQPopupMenu *);

public slots:
    void raiseLastActiveWindow();

protected slots:
    void subItemActivated(int);
    void blinkDockedIcon(void);
    void blinkClear(void);
    void mainActivated(int id);
    void helpNotice();
    void configNotify();

    void mainPopShow();
    void mainPopHide();

private:
    int intoPopupSorted(TQString, TQPopupMenu *);
    void createMainPopup();
    void raiseWindow(TQString server, TQString name);
    TQDict<dscNickInfo> m_nicks;
    servercontroller *m_sc;
    TDEPopupMenu *mainPop;

    TQString m_last_nick;
    TQString m_last_server;

    TQPixmap m_pic_dock;
    TQPixmap m_pic_info;

    bool m_mainPopVisible;

    bool m_blinkActive;
    bool m_blinkStatus; // true: blue icon, false: normal icon
    TQTimer* m_blinkTimer;

    TQStringList m_blink_reason;

};

#endif

