/*
 *
 * $Id$
 *
 * This file is part of the TDE project, module kstartperf.
 * Copyright (C) 2000 Geert Jansen <jansen@kde.org> 
 *
 * You can freely redistribute this program under the "Artistic License".
 * See the file "LICENSE.readme" for the exact terms.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>

#include <tqstring.h>
#include <tqtextstream.h>
#include <tqfile.h>

#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kstandarddirs.h>


static TDECmdLineOptions options[] = 
{
    { "+command", I18N_NOOP("Specifies the command to run"), 0 },
    TDECmdLineLastOption
};


TQString libkstartperf()
{
    TQString lib = TQString();
    TQString la_file = locate("lib", "libkstartperf.la");

    if (la_file.isEmpty())
	return lib;

    // Find the name of the .so file by reading the .la file
    TQFile la(la_file);
    if (la.open(IO_ReadOnly))
    {
	TQTextStream is(&la);
	TQString line;

	while (!is.atEnd())
        {
	    line = is.readLine();
            if (line.left(15) == "library_names='")
            {
		lib = line.mid(15);
                int pos = lib.find(" ");
                if (pos > 0)
		    lib = lib.left(pos);
	    }
	}

        la.close();
    }

    // Look up the actual .so file.
    lib = locate("lib", lib);
    return lib;
}


int main(int argc, char **argv)
{
    TDEAboutData aboutData("kstartperf", I18N_NOOP("KStartPerf"),
	    "1.0", I18N_NOOP("Measures start up time of a TDE application"),
	    TDEAboutData::License_Artistic, 
	    "Copyright (c) 2000 Geert Jansen and libkmapnotify authors");
    aboutData.addAuthor("Geert Jansen", I18N_NOOP("Maintainer"),
	    "jansen@kde.org", "http://www.stack.nl/~geertj/");

    TDECmdLineArgs::init(argc, argv, &aboutData);
    TDECmdLineArgs::addCmdLineOptions(options);
    TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

    TDEApplication *app = new TDEApplication(false, false);

    // Check arguments

    if (args->count() == 0)
    {
	fprintf(stderr, "No command specified!\n");
	fprintf(stderr, "usage: kstartperf command [arguments]\n");
	exit(1);
    }
    
    // Build command

    char cmd[1024];
    sprintf(cmd, "LD_PRELOAD=%s %s", libkstartperf().latin1(), args->arg(0));
    for (int i=1; i<args->count(); i++)
    {
	strcat(cmd, " ");
	strcat(cmd, args->arg(i));
    }

    // Put the current time in the environment variable `KSTARTPERF'

    struct timeval tv;
    if (gettimeofday(&tv, 0L) != 0)
    {
	perror("gettimeofday()");
	exit(1);
    }
    char env[100];
    sprintf(env, "KSTARTPERF=%ld:%ld", tv.tv_sec, tv.tv_usec);
    putenv(env);

    // And exec() the command

    execl("/bin/sh", "sh", "-c", cmd, (void *)0);

    perror("execl()");
    exit(1);
}
