/*
    This file is part of KOrganizer.

    Copyright (c) 1999 Preston Brown <pbrown@kde.org>
    Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef _KOLISTVIEW_H
#define _KOLISTVIEW_H

#include <tqdict.h>
#include <tqmap.h>
#include <tqtooltip.h>

#include <libkcal/incidence.h>

#include "koeventview.h"
#include "customlistviewitem.h"

using namespace KCal;

typedef CustomListViewItem<Incidence *> KOListViewItem;

class KOListView;

class KOListViewToolTip : public TQToolTip
{
  public:
    KOListViewToolTip ( TQWidget* parent, Calendar *calendar, TDEListView* lv );

  protected:
    void maybeTip( const TQPoint &pos );

  private:
    Calendar *mCalendar;
    TDEListView* eventlist;
};


/**
  This class provides a multi-column list view of events.  It can
  display events from one particular day or several days, it doesn't
  matter.  To use a view that only handles one day at a time, use
  KODayListView.

  @short multi-column list view of various events.
  @author Preston Brown <pbrown@kde.org>
  @see KOBaseView, KODayListView
*/
class KOListView : public KOEventView
{
    TQ_OBJECT
  
  public:
   explicit KOListView( Calendar *calendar,
                        TQWidget *parent = 0,
                        const char *name = 0,
                        bool nonInteractive = false );
    ~KOListView();

    virtual int maxDatesHint();
    virtual int currentDateCount();
    virtual Incidence::List selectedIncidences();
    virtual DateList selectedIncidenceDates();

    void showDates( bool show );

    // Shows all incidences of the calendar
    void showAll();

    void readSettings(TDEConfig *config);
    void writeSettings(TDEConfig *config);

    void clear();
    TQSize sizeHint() const;

  public slots:
    virtual void updateView();
    virtual void showDates( const TQDate &start, const TQDate &end );
    virtual void showIncidences( const Incidence::List &incidenceList, const TQDate &date );

    void clearSelection();

    void showDates();
    void hideDates();

    void changeIncidenceDisplay(Incidence *, int);

    void defaultItemAction(TQListViewItem *item);
    void popupMenu(TQListViewItem *item,const TQPoint &,int);

  protected slots:
    void processSelectionChange();

  protected:
    void addIncidences(const Incidence::List &, const TQDate &date);
    void addIncidence(Incidence *,  const TQDate &date);
    KOListViewItem *getItemForIncidence(Incidence *incidence);

  private:
    class ListItemVisitor;
    TDEListView *mListView;
    KOEventPopupMenu *mPopupMenu;
    KOListViewItem *mActiveItem;
    TQDict<Incidence> mUidDict;
    TQMap<TQString, TQDate>mDateList;
    DateList mSelectedDates;

    // if it's non interactive we disable context menu, and incidence editing
    bool mIsNonInteractive;
};

#endif
