// Copyright (C)  2003  Dominique Devriese <devriese@kde.org>

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#include "newscriptwizard.h"
#include "newscriptwizard.moc"

#include "script_mode.h"

#include <tqlabel.h>
#include <tqlayout.h>

//#include <tdeactionclasses.h>
//#include <tdeactioncollection.h>
// make it still work on old kde 3.1...
#include <tdeaction.h>
//
#include <tdeapplication.h>
#include <tdeglobalsettings.h>
#include <tdepopupmenu.h>
#include <ktextedit.h>
#include <tdetexteditor/clipboardinterface.h>
#include <tdetexteditor/dynwordwrapinterface.h>
#include <tdetexteditor/editinterface.h>
#include <tdetexteditor/editorchooser.h>
#include <tdetexteditor/popupmenuinterface.h>
#include <tdetexteditor/undointerface.h>
#include <tdetexteditor/view.h>

#include <assert.h>

NewScriptWizard::~NewScriptWizard()
{
  if ( !document )
  {
    delete textedit;
  }
  else
  {
    //restoring the state of the dynamic word wrap
    dynamic_cast<KTextEditor::DynWordWrapInterface*>( editor )->setDynWordWrap( prevDynWordWrap );
    delete editor->document();
  }
}

NewScriptWizard::NewScriptWizard( TQWidget* parent, ScriptModeBase* mode )
  : NewScriptWizardBase( parent, "New Script Wizard" ),
    mmode( mode )
{
  document = KTextEditor::EditorChooser::createDocument( 0, "KTextEditor::Document" );
//  document = 0;

  gridLayout->expand( 2, 1 );

  if ( !document )
  {
    // there is no KDE textditor component installed, so we'll use a
    // simplier KTextEdit
    textedit = new KTextEdit( mpcode, "textedit" );
    textedit->setFont( TDEGlobalSettings::fixedFont() );
    gridLayout->addWidget( textedit, 1, 0 );
  }
  else
  {
    // creating the 'view', hat is what the user see and interact with
    editor = document->createView( mpcode, "editor" );
    gridLayout->addWidget( editor, 1, 0 );

    // casting to the interfaces we'll use often
    hli = dynamic_cast<KTextEditor::HighlightingInterface*>( document );

    // displaying the left border with line numbers
    TDEToggleAction *a = dynamic_cast<TDEToggleAction*>( editor->actionCollection()->action("view_line_numbers") );
    a->activate();

    // saving the state of dynamic word wrap and disabling it
    prevDynWordWrap = dynamic_cast<KTextEditor::DynWordWrapInterface*>( editor )->dynWordWrap();
    dynamic_cast<KTextEditor::DynWordWrapInterface*>( editor )->setDynWordWrap( false );

    // saving the "no highlight" id
    noHlStyle = hli->hlMode();

    // creating the popup menu
    TDEPopupMenu* pm = new TDEPopupMenu( editor );
    // creating the actions for the code editor...
    TDEActionCollection* ac = new TDEActionCollection( editor );
    TDEAction* undoAction = KStdAction::undo( this, TQ_SLOT( slotUndo() ), ac );
    TDEAction* redoAction = KStdAction::redo( this, TQ_SLOT( slotRedo() ), ac );
    TDEAction* cutAction = KStdAction::cut( this, TQ_SLOT( slotCut() ), ac );
    TDEAction* copyAction = KStdAction::copy( this, TQ_SLOT( slotCopy() ), ac );
    TDEAction* pasteAction = KStdAction::paste( this, TQ_SLOT( slotPaste() ), ac );
    // ... and plugging them into the popup menu (to build it, of course :) )
    undoAction->plug( pm );
    redoAction->plug( pm );
    pm->insertSeparator();
    cutAction->plug( pm );
    copyAction->plug( pm );
    pasteAction->plug( pm );

    // finally, we install the popup menu
    dynamic_cast<KTextEditor::PopupMenuInterface*>( editor )->installPopup( pm );
  }

  connect( this, TQ_SIGNAL( helpClicked() ), this, TQ_SLOT( slotHelpClicked() ) );
}

void NewScriptWizard::back()
{
  if ( currentPage() == mpcode )
  {
    // currentPage() is not yet updated, so we're now entering the
    // args page..
    mmode->argsPageEntered();
  }
  else assert( false );
  NewScriptWizardBase::back();
}

void NewScriptWizard::next()
{
  if ( currentPage() == mpargs )
    mmode->codePageEntered();
  else assert( false );
  if ( !document )
  {
    textedit->setFocus();
  }
  else
  {
    editor->setFocus();
  }
  NewScriptWizardBase::next();
}

void NewScriptWizard::reject()
{
  if ( mmode->queryCancel() )
    NewScriptWizardBase::reject();
}

void NewScriptWizard::accept()
{
  if ( mmode->queryFinish() )
    NewScriptWizardBase::accept();
}

void NewScriptWizard::slotHelpClicked()
{
  kapp->invokeHelp( TQString::fromLatin1( "scripting" ),
                    TQString::fromLatin1( "kig" ) );
}

void NewScriptWizard::setText( const TQString& text )
{
  if ( !document )
  {
    textedit->setText( text );
  }
  else
  {
    dynamic_cast<KTextEditor::EditInterface*>( document )->setText( text );
  }
}

TQString NewScriptWizard::text()
{
  if ( !document )
  {
    return textedit->text();
  }
  else
  {
    return dynamic_cast<KTextEditor::EditInterface*>( document )->text();
  }
}

void NewScriptWizard::setType( ScriptType::Type type )
{
  labelFillCode->setText( ScriptType::fillCodeStatement( type ) );

  if ( !!document )
  {
    if ( type != ScriptType::Unknown )
    {
      for ( uint i = 0; i < hli->hlModeCount(); ++i )
      {
        if ( hli->hlModeName( i ) == ScriptType::highlightStyle( type ) )
        {
          // we found our highlight style, setting it
          hli->setHlMode( i );
          return;
        }
      }
    }
    else
    {
      hli->setHlMode( noHlStyle );
    }
  }
}

void NewScriptWizard::slotUndo()
{
  dynamic_cast<KTextEditor::UndoInterface*>( document )->undo();
}

void NewScriptWizard::slotRedo() {
  dynamic_cast<KTextEditor::UndoInterface*>( document )->redo();
}

void NewScriptWizard::slotCut() {
  dynamic_cast<KTextEditor::ClipboardInterface*>( editor )->cut();
}

void NewScriptWizard::slotCopy() {
  dynamic_cast<KTextEditor::ClipboardInterface*>( editor )->copy();
}

void NewScriptWizard::slotPaste() {
  dynamic_cast<KTextEditor::ClipboardInterface*>( editor )->paste();
}
