/*
 * Copyright (C) 2004 Stephan Mres <Erdling@gmx.net>
 */

#ifndef _PLUGIN_KATESNIPPETS_H_
#define _PLUGIN_KATESNIPPETS_H_

#include <kate/application.h>
#include <kate/documentmanager.h>
#include <kate/document.h>
#include <kate/mainwindow.h>
#include <kate/plugin.h>
#include <kate/view.h>
#include <kate/viewmanager.h>
#include <klibloader.h>
#include <tdelocale.h>

#include <kate/toolviewmanager.h>

#include <tqlistview.h>
#include <tqregexp.h>
#include <tdeconfig.h>
#include <tqptrlist.h>
#include <tqtoolbutton.h>
#include <tqtextedit.h>
#include <kiconloader.h>

#include "csnippet.h"
#include "cwidgetsnippets.h"

class KatePluginSnippetsView : public CWidgetSnippets, public KXMLGUIClient {

  TQ_OBJECT
  

  friend class KatePluginSnippets;

public:
  KatePluginSnippetsView (Kate::MainWindow *w, TQWidget *dock);
  virtual ~KatePluginSnippetsView ();
  CSnippet* findSnippetByListViewItem(TQListViewItem *item);

public slots:
  void slot_lvSnippetsSelectionChanged(TQListViewItem  * item);
  void slot_lvSnippetsClicked (TQListViewItem * item);
  void slot_lvSnippetsItemRenamed(TQListViewItem *lvi,int col, const TQString& text);
  void slot_btnNewClicked();
  void slot_btnSaveClicked();
  void slot_btnDeleteClicked();

protected:
  void readConfig();
  void writeConfig();

private:
  TDEConfig                                 *config;
  TQPtrList<CSnippet>                      lSnippets;

public:
  Kate::MainWindow *win;
  TQWidget *dock;
};

class KatePluginSnippets : public Kate::Plugin, Kate::PluginViewInterface {
  TQ_OBJECT
  

public:
  KatePluginSnippets( TQObject* parent = 0, const char* name = 0, const TQStringList& = TQStringList() );
  virtual ~KatePluginSnippets();

  void addView (Kate::MainWindow *win);
  void removeView (Kate::MainWindow *win);

private:
  TQPtrList<class KatePluginSnippetsView>  m_views;

};

#endif // _PLUGIN_KATESNIPPETS_H_
