/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2005 Francois Chazal <neptune3k@free.fr>
  Copyright (C) 2006-2007 Eike Hein <hein@kde.org>
*/


#ifndef TITLE_BAR_H
# define TITLE_BAR_H

#include "image_button.h"

#include <tqurl.h>
#include <tqcolor.h>
#include <tqpoint.h>
#include <tqbitmap.h>
#include <tqpixmap.h>
#include <tqwidget.h>
#include <tqpainter.h>
#include <tqpushbutton.h>


#include <tdeconfig.h>
#include <tdepopupmenu.h>
#include <tdeapplication.h>
#include <tdestandarddirs.h>


class TitleBar : public TQWidget
{
    TQ_OBJECT
  

    public:
        explicit TitleBar(TQWidget * parent = 0, const char * name = 0, const TQString & skin = "default");
        ~TitleBar();

        TQRegion& getWidgetMask();

        void setTitleText(const TQString& title);

        void setFocusButtonEnabled(bool enable);

        void setConfigurationMenu(TDEPopupMenu* menu);

        void reloadSkin(const TQString& skin);


    protected:
        virtual void paintEvent(TQPaintEvent*);
        virtual void resizeEvent(TQResizeEvent*);


    private:
        void setPixmaps(const TQString& skin);
        void loadSkin(const TQString& skin);
        void updateWidgetMask();

        /* Widget's mask */
        TQRegion mask;

        /* Text properties */
        TQString title_text;
        TQString skin_text;
        TQColor text_color;
        TQPoint text_position;

        /* Widget's pixmaps */
        TQPixmap back_image;
        TQPixmap left_corner;
        TQPixmap right_corner;

        /* Quit button */
        TQPoint quit_position;
        ImageButton* quit_button;

        /* Focus button */
        TQPoint focus_position;
        ImageButton* focus_button;

        /* Configure button */
        TQPoint config_position;
        ImageButton* config_button;
};

#endif /* TITLE_BAR_H */
