//
// C++ Interface: malloryhandler
//
// Description:
//
//
// Author: Remi Villatel <maxilys@tele2.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MALLORYHANDLER_H
#define MALLORYHANDLER_H

#include <kdecorationfactory.h>
#include <kdecoration.h>
#include <tqobject.h>
#include <tdeconfig.h>

// Default button layout
const char default_left[]  = "M";
const char default_right[] = "HIAX";

class MalloryHandler : public TQObject, public KDecorationFactory
{
TQ_OBJECT
public:
	MalloryHandler();
	~MalloryHandler();
	virtual bool reset(unsigned long changed);

	virtual KDecoration* createDecoration(KDecorationBridge*);

	static bool initialized() { return m_initialized; }
	static bool titleShadow() { return m_titleShadow; }
	static int titleShadowSize() { return m_titleShadowSize; }
	static int borderSize() { return m_borderSize; }
	static int buttonSize() { return m_buttonSize; }
	static int buttonStyle() { return m_buttonStyle; }
	static int buttonSpacing() { return m_buttonSpacing; }
	static int titleSize() { return m_titleSize; }
	static bool lessRounded() { return m_lessRounded; }
	static bool resizeHandle() { return m_resizeHandle; }
	static bool superSize() { return m_superSize; }

private:
	void readConfig();
	static bool m_titleShadow;
	static int m_titleShadowSize;
	static int m_borderSize;
	static int m_buttonSize;
	static int m_buttonStyle;
	static int m_titleSize;
	static int m_buttonSpacing;
	static bool m_initialized;
	static bool m_lessRounded;
	static bool m_resizeHandle;
	static bool m_superSize;
};

#endif
