// This defines the interface to the TQextScintillaLexerJavaScript class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifndef TQEXTSCINTILLALEXERJSCRIPT_H
#define TQEXTSCINTILLALEXERJSCRIPT_H


#include <tqobject.h>

#include <tqextscintillaglobal.h>
#include <tqextscintillalexercpp.h>


//! \brief The TQextScintillaLexerJavaScript class encapsulates the Scintilla
//! JavaScript lexer.
class TQEXTSCINTILLA_EXPORT TQextScintillaLexerJavaScript : public TQextScintillaLexerCPP
{
	TQ_OBJECT
  

public:
	//! Construct a TQextScintillaLexerJavaScript with parent \a parent and
	//! name \a name.  \a parent is typically the TQextScintilla instance.
	TQextScintillaLexerJavaScript(TQObject *parent = 0,const char *name = 0);

	//! Destroys the TQextScintillaLexerJavaScript instance.
	virtual ~TQextScintillaLexerJavaScript();

	//! Returns the name of the language.
	const char *language() const;

	//! Returns the foreground colour of the text for style number
	//! \a style.
	//!
	//! \sa paper()
	TQColor color(int style) const;

	//! Returns the end-of-line fill for style number \a style.
	bool eolFill(int style) const;

	//! Returns the font for style number \a style.
	TQFont font(int style) const;

	//! Returns the set of keywords for the keyword set \a set recognised
	//! by the lexer as a space separated string.
	const char *keywords(int set) const;

	//! Returns the descriptive name for style number \a style.  If the
	//! style is invalid for this language then TQString() is returned.
	//! This is intended to be used in user preference dialogs.
	TQString description(int style) const;

	//! Returns the background colour of the text for style number
	//! \a style.
	//!
	//! \sa color()
	TQColor paper(int style) const;

private:
	friend class TQextScintillaLexerHTML;

	static const char *keywordClass;

#if defined(TQ_DISABLE_COPY)
	TQextScintillaLexerJavaScript(const TQextScintillaLexerJavaScript &);
	TQextScintillaLexerJavaScript &operator=(const TQextScintillaLexerJavaScript &);
#endif
};

#endif
