// This defines the interface to the TQextScintillaDocument class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifndef TQEXTSCINTILLADOCUMENT_H
#define TQEXTSCINTILLADOCUMENT_H


#include <tqextscintillaglobal.h>


class TQextScintillaBase;
class TQextScintillaDocumentP;


//! \brief The TQextScintillaDocument class represents a document to be editted.
//!
//! It is an opaque class that can be attached to multiple instances of
//! TQextScintilla to create different simultaneous views of the same document.
//! TQextScintillaDocument uses implicit sharing so that copying class instances
//! is a cheap operation.
class TQEXTSCINTILLA_EXPORT TQextScintillaDocument
{
public:
	//! Create a new unattached document.
	TQextScintillaDocument();
	virtual ~TQextScintillaDocument();

	TQextScintillaDocument(const TQextScintillaDocument &);
	TQextScintillaDocument &operator=(const TQextScintillaDocument &);

private:
	friend class TQextScintilla;

	void attach(const TQextScintillaDocument &that);
	void detach();
	void display(TQextScintillaBase *tqsb,const TQextScintillaDocument *from);
	void undisplay(TQextScintillaBase *tqsb);

	TQextScintillaDocumentP *pdoc;
};

#endif
