/***************************************************************************
 *   Copyright (C) 2006 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqlistview.h>
#include <tqheader.h>
#include <tqlabel.h>
#include <tqregexp.h>

#include <kdebug.h>
#include <tdeapplication.h>
#include <kurllabel.h>

#include "kdevplugin.h"
#include "projectmanager.h"
#include "plugincontroller.h"
#include "pluginselectdialog.h"

class PluginItem : public TQCheckListItem
{
public:
	// name - "Name", label - "GenericName", info - "Comment"
	PluginItem( TQListView * parent, TQString const & name, TQString const & label,
				TQString const & info, TQString const url = TQString() )
		: TQCheckListItem( parent, label, TQCheckListItem::CheckBox),
		_name( name ), _info( info ), _url( url )
	{}

	TQString info() { return _info; }
	TQString name() { return _name; }
	TQString url()  { return _url; }

private:
	TQString _name;
	TQString _info;
	TQString _url;
};


PluginSelectDialog::PluginSelectDialog(TQWidget* parent, const char* name, bool modal, WFlags fl )
	: PluginSelectDialogBase( parent,name, modal,fl )
{
	plugin_list->setResizeMode( TQListView::LastColumn );
	plugin_list->addColumn("");
	plugin_list->header()->hide();

	connect( plugin_list, TQ_SIGNAL( selectionChanged( TQListViewItem * ) ), this, TQ_SLOT( itemSelected( TQListViewItem * ) ) );
	connect( urllabel, TQ_SIGNAL( leftClickedURL( const TQString & ) ), this, TQ_SLOT( openURL( const TQString & ) ) );

	init();
}

PluginSelectDialog::~PluginSelectDialog()
{
}

void PluginSelectDialog::saveAsDefault()
{
	kdDebug(9000) << k_funcinfo << endl;

	ProfileEngine & engine = PluginController::getInstance()->engine();
	Profile * profile = engine.findProfile( PluginController::getInstance()->currentProfile() );

	profile->clearList( Profile::ExplicitDisable );

	TQListViewItemIterator it( plugin_list );
	while ( it.current() )
	{
		PluginItem * item = static_cast<PluginItem*>( it.current() );
		if ( !item->isOn() )
		{
			profile->addEntry( Profile::ExplicitDisable, item->name() );
		}
		++it;
	}

	profile->save();
}

void PluginSelectDialog::openURL( const TQString & url )
{
	tdeApp->invokeBrowser( url );
}

void PluginSelectDialog::itemSelected( TQListViewItem * item )
{
    if ( ! item ) return;

    PluginItem * pitem = static_cast<PluginItem*>( item );
    plugin_description_label->setText( pitem->info() );

	if ( pitem->url().isEmpty() )
	{
		urllabel->clear();
	}
	else
	{
		urllabel->setURL( pitem->url() );
		urllabel->setText( pitem->url() );
	}
}

void PluginSelectDialog::init( )
{
	const TQValueList<KDevPlugin*> loadedPlugins = PluginController::getInstance()->loadedPlugins();
	TQStringList loadedPluginDesktopNames;
	TQValueList<KDevPlugin*>::ConstIterator it = loadedPlugins.begin();
	while( it != loadedPlugins.end() )
	{
		loadedPluginDesktopNames << (*it)->instance()->instanceName();
		++it;
	}

	kdDebug(9000) << " *** loadedPluginDesktopNames: " << loadedPluginDesktopNames << endl;

	TDETrader::OfferList localOffers;
	if ( ProjectManager::getInstance()->projectLoaded() )
	{
		localOffers = PluginController::getInstance()->engine().offers(
			PluginController::getInstance()->currentProfile(), ProfileEngine::Project );
	}

	TDETrader::OfferList globalOffers = PluginController::getInstance()->engine().offers(
		PluginController::getInstance()->currentProfile(), ProfileEngine::Global);

	TDETrader::OfferList offers = localOffers + globalOffers;
	for (TDETrader::OfferList::ConstIterator it = offers.begin(); it != offers.end(); ++it)
	{
		// parse out any existing url to make it clickable
		TQString Comment = (*it)->comment();
		TQRegExp re("\\bhttp://[\\S]*");
		re.search( Comment );
		Comment.replace( re, "" );

		TQString url;
		if ( re.pos() > -1 )
		{
			url = re.cap();
		}

		PluginItem *item = new PluginItem( plugin_list, (*it)->desktopEntryName(), (*it)->genericName(), Comment, url );
		item->setOn( loadedPluginDesktopNames.contains( (*it)->desktopEntryName() ) );

		kdDebug(9000) << (*it)->desktopEntryName() << " : " << (loadedPluginDesktopNames.contains( (*it)->desktopEntryName() ) ? "YES" : "NO" ) << endl;
	}

	TQListViewItem * first = plugin_list->firstChild();
	if ( first )
	{
		plugin_list->setSelected( first, true );
	}
}

TQStringList PluginSelectDialog::unselectedPluginNames( )
{
	TQStringList unselectedPlugins;
	TQListViewItem * item = plugin_list->firstChild();
	while ( item )
	{
		PluginItem * pluginItem = static_cast<PluginItem*>( item );
		if ( !pluginItem->isOn() )
		{
			unselectedPlugins << pluginItem->name();
		}
		item = item->nextSibling();
	}
	return unselectedPlugins;
}



#include "pluginselectdialog.moc"
