/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filegroupspart.h"
#include "filegroupspart.moc"

#include <tqwhatsthis.h>
#include <tqvbox.h>
#include <tqtimer.h>
#include <tdeaction.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kdevgenericfactory.h>
#include <kdialogbase.h>

#include "kdevcore.h"
#include "kdevproject.h"
#include "kdevmainwindow.h"
#include "kdevplugininfo.h"

#include "filegroupswidget.h"
#include "filegroupsconfigwidget.h"

#define FILEGROUPS_OPTIONS 1

typedef KDevGenericFactory<FileGroupsPart> FileGroupsFactory;
static const KDevPluginInfo pluginData("kdevfilegroups");
K_EXPORT_COMPONENT_FACTORY( libkdevfilegroups, FileGroupsFactory( pluginData ) )

FileGroupsPart::FileGroupsPart(TQObject *parent, const char *name, const TQStringList &)
    : KDevPlugin(&pluginData, parent, name ? name : "FileGroupsPart")
{
    deleteRequested = false;
    setInstance(FileGroupsFactory::instance());

    m_filegroups = new FileGroupsWidget(this);
    m_filegroups->setCaption(i18n("File Group View"));
	m_filegroups->setIcon(SmallIcon( info()->icon() ) );
    TQWhatsThis::add(m_filegroups, i18n("<b>File group view</b><p>"
                                       "The file group viewer shows all files of the project, "
                                       "in groups which can be configured in project settings dialog, <b>File Groups</b> tab."));
    mainWindow()->embedSelectView(m_filegroups, i18n("File Groups"), i18n("File groups in the project directory"));

	_configProxy = new ConfigWidgetProxy( core() );
	_configProxy->createProjectConfigPage( i18n("File Groups"), FILEGROUPS_OPTIONS, info()->icon() );
	connect( _configProxy, TQ_SIGNAL(insertConfigWidget(const KDialogBase*, TQWidget*, unsigned int )), 
		this, TQ_SLOT(insertConfigWidget(const KDialogBase*, TQWidget*, unsigned int )) );


    // File groups
    connect( project(), TQ_SIGNAL(addedFilesToProject(const TQStringList&)),
             m_filegroups, TQ_SLOT(addFiles(const TQStringList&)) );
    connect( project(), TQ_SIGNAL(removedFilesFromProject(const TQStringList&)),
             m_filegroups, TQ_SLOT(removeFiles(const TQStringList&)) );
/*    connect( project(), TQ_SIGNAL(addedFileToProject(const TQString&)),
             m_filegroups, TQ_SLOT(addFile(const TQString&)) );
    connect( project(), TQ_SIGNAL(removedFileFromProject(const TQString&)),
             m_filegroups, TQ_SLOT(removeFile(const TQString&)) );*/
    m_filegroups->refresh();
}

FileGroupsPart::~FileGroupsPart()
{
    deleteRequested = true;
    if (m_filegroups)
        mainWindow()->removeView(m_filegroups);
    delete m_filegroups;
	delete _configProxy;
}

void FileGroupsPart::refresh()
{
    if (deleteRequested)
        return;
    // This method may be called from m_filetree's slot,
    // so we make sure not to modify the list view during
    // the execution of the slot
    TQTimer::singleShot(0, m_filegroups, TQ_SLOT(refresh()));
}

void FileGroupsPart::insertConfigWidget( const KDialogBase * dlg, TQWidget * page, unsigned int pagenumber )
{
	if ( pagenumber == FILEGROUPS_OPTIONS )
	{
		FileGroupsConfigWidget *w = new FileGroupsConfigWidget(this, page, "file groups config widget");
		connect( dlg, TQ_SIGNAL(okClicked()), w, TQ_SLOT(accept()) );
	}
}
