/***************************************************************************
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqdir.h>
#include <tqwidget.h>
#include <tqtimer.h>

#include "appwizardpart.h"

#include <kdebug.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeprocess.h>
#include <kdevcore.h>
#include <kgenericfactory.h>
#include <tdestandarddirs.h>
#include <tdeaction.h>
#include <tqmessagebox.h>

#include "importdlg.h"
#include "appwizarddlg.h"
#include "appwizardfactory.h"
#include <kdevmakefrontend.h>
#include <kdevpartcontroller.h>
#include <kdevlanguagesupport.h>
#include <kdevcore.h>
#include <codemodel.h>

AppWizardPart::AppWizardPart(TQObject *parent, const char *name, const TQStringList &)
    : KDevPlugin(AppWizardFactory::info(), parent, name ? name : "AppWizardPart")
{
    setInstance(AppWizardFactory::instance());
    setXMLFile("kdevappwizard.rc");

    TDEAction *action;

    action = new TDEAction( i18n("&New Project..."), "window-new", 0,
                          this, TQ_SLOT(slotNewProject()),
                          actionCollection(), "project_new" );
    action->setToolTip( i18n("Generate a new project from a template") );
    action->setWhatsThis( i18n("<b>New project</b><p>"
                               "This starts KDevelop's application wizard. "
                               "It helps you to generate a skeleton for your "
                               "application from a set of templates.") );

    action = new TDEAction( i18n("&Import Existing Project..."),"wizard", 0,
                          this, TQ_SLOT(slotImportProject()),
                          actionCollection(), "project_import" );
    action->setToolTip( i18n("Import existing project") );
    action->setWhatsThis( i18n("<b>Import existing project</b><p>Creates a project file for a given directory.") );
}


AppWizardPart::~AppWizardPart()
{
}


void AppWizardPart::slotNewProject()
{
    kdDebug(9010) << "new project" << endl;
    AppWizardDialog dlg(this, 0, "app wizard");
    dlg.templates_listview->setFocus();
    dlg.exec();
}


void AppWizardPart::slotImportProject()
{
    ImportDialog dlg(this, 0, "import dialog");
    dlg.exec();
}

void AppWizardPart::openFilesAfterGeneration(const KURL::List urlsToOpen)
{
	m_urlsToOpen = urlsToOpen;
	connect( core(), TQ_SIGNAL( projectOpened() ), this, TQ_SLOT( openFilesAfterGeneration() ) );
}

void AppWizardPart::openFilesAfterGeneration()
{
	for (KURL::List::const_iterator it = m_urlsToOpen.begin(); it != m_urlsToOpen.end(); ++it)
		partController()->editDocument(*it);
	m_urlsToOpen.clear();
	disconnect( core(), TQ_SIGNAL( projectOpened() ), this, TQ_SLOT( openFilesAfterGeneration() ) );
}

#include "appwizardpart.moc"
