=begin
  This class serves as the main window for %{APPNAME}.  It handles the
  menus, toolbars, and status bars.
 
  @short Main window class
  @author %{AUTHOR} <%{EMAIL}>
  @version %{VERSION}
=end

class %{APPNAMESC} < KDE::MainWindow

    slots 'fileNew()',
          'fileOpen()',
          'fileSave()',
          'fileSaveAs()',
          'filePrint()',
          'optionsPreferences()',
          'changeStatusbar(const TQString&)',
          'changeCaption(const TQString&)'

    def initialize()
        super( nil, "%{APPNAMESC}" )
        @view = %{APPNAMESC}View.new(self)
        @printer = nil
        # accept dnd
        setAcceptDrops(true)
    
        # tell the KDE::MainWindow that this is indeed the main widget
        setCentralWidget(@view)
    
        # then, setup our actions
        setupActions()
    
        # and a status bar
        statusBar().show()
    
        # Apply the create the main window and ask the mainwindow to
        # automatically save settings if changed: window size, toolbar
        # position, icon size, etc.  Also to add actions for the statusbar
        # toolbar, and keybindings if necessary.
        setupGUI();
    
        # allow the view to change the statusbar and caption
        connect(@view, TQ_SIGNAL('signalChangeStatusbar(const TQString&)'),
                self,   TQ_SLOT('changeStatusbar(const TQString&)'))
        connect(@view, TQ_SIGNAL('signalChangeCaption(const TQString&)'),
                self,   TQ_SLOT('changeCaption(const TQString&)'))
    
    end
    
    
    def load(url)
        target = ""
        # the below code is what you should normally do.  in this
        # example when, we want the url to our own.  you probably
        # want to use this code instead for your app
    
        if false
        # download the contents
        if TDEIO::NetAccess.download(url, target, self)
            # set our caption
            setCaption(url.url)
    
            # load in the file (target is always local)
            @view.openURL(KDE::URL.new(target))
    
            # and remove the temp file
            TDEIO::NetAccess.removeTempFile(target)
        end
        end
    
        setCaption(url.prettyURL())
        @view.openURL(url)
    end
    
    def setupActions()
        KDE::StdAction.openNew(self, TQ_SLOT('fileNew()'), actionCollection())
        KDE::StdAction.open(self, TQ_SLOT('fileOpen()'), actionCollection())
        KDE::StdAction.save(self, TQ_SLOT('fileSave()'), actionCollection())
        KDE::StdAction.saveAs(self, TQ_SLOT('fileSaveAs()'), actionCollection())
        KDE::StdAction.print(self, TQ_SLOT('filePrint()'), actionCollection())
        KDE::StdAction.quit($tdeApp, TQ_SLOT('quit()'), actionCollection())
    
        KDE::StdAction.preferences(self, TQ_SLOT('optionsPreferences()'), actionCollection())
    
        # this doesn't do anything useful.  it's just here to illustrate
        # how to insert a custom menu and menu item
        custom = KDE::Action.new(i18n("Cus&tom Menuitem"), KDE::Shortcut.new(),
                                    self, TQ_SLOT('optionsPreferences()'),
                                    actionCollection(), "custom_action")
    end
    
    def saveProperties(config)
        # the 'config' object points to the session managed
        # config file.  anything you write here will be available
        # later when this app is restored
    
        if !@view.currentURL().empty?
            config.writeEntry("lastURL", @view.currentURL())
        end
    end
    
    def readProperties(config)
        # the 'config' object points to the session managed
        # config file.  This function is automatically called whenever
        # the app is being restored.  read in here whatever you wrote
        # in 'saveProperties'
    
        url = config.readPathEntry("lastURL")
    
        if !url.empty?
            @view.openURL(KDE::URL.new(url))
        end
    end
    
    def dragEnterEvent(event)
        # accept uri drops only
        event.accept(KDE::URLDrag.canDecode(event))
    end
    
    def dropEvent(event)
        # This is a very simplistic implementation of a drop event.  we
        # will only accept a dropped URL.  the Qt dnd code can do *much*
        # much more, so please read the docs there
        urls = []
    
        # see if we can decode a URI.. if not, just ignore it
        if KDE::URLDrag.decode(event, urls) && !urls.empty?
            # okay, we have a URI.. process it
            url = urls.shift
    
            # load in the file
            load(url)
        end
    end
    
    def fileNew()
        # This slot is called whenever the File.New menu is selected,
        # the New shortcut is pressed (usually CTRL+N) or the New toolbar
        # button is clicked
    
        # create a new window
        %{APPNAMESC}.new.show()
    end
    
    def fileOpen()
        # This slot is called whenever the File.Open menu is selected,
        # the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
        # button is clicked
    
        # This brings up the generic open dialog
        url = KDE::URLRequesterDlg.getURL(nil, self, i18n("Open Location") )
    
        # standard filedialog
        url = KDE::FileDialog.getOpenURL(nil, nil, self, i18n("Open Location"))
        if !url.empty?
            @view.openURL(url)
        end
    end
    
    def fileSave()
        # This slot is called whenever the File.Save menu is selected,
        # the Save shortcut is pressed (usually CTRL+S) or the Save toolbar
        # button is clicked
    
        # save the current file
    end
    
    def fileSaveAs()
        # This slot is called whenever the File.Save As menu is selected,
        file_url = KDE::FileDialog.getSaveURL()
        if !file_url.empty? && file_url.valid?
            # save your info, here
        end
    end
    
    def filePrint()
        # This slot is called whenever the File.Print menu is selected,
        # the Print shortcut is pressed (usually CTRL+P) or the Print toolbar
        # button is clicked
        if @printer.nil? then @printer = KDE::Printer.new end
        if @printer.setup(self)
            # setup the printer.  with Qt, you always "print" to a
            # TQt::Painter.. whether the output medium is a pixmap, a screen,
            # or paper
            p = TQt::Painter.new
            p.begin(@printer)
    
            # we let our view do the actual printing
            metrics = TQt::PaintDeviceMetrics.new(@printer)
            @view.print(p, metrics.height(), metrics.width())
    
            # and send the result to the printer
            p.end()
        end
    end
        
    def optionsPreferences()
        # popup some sort of preference dialog, here
        dlg = %{APPNAMESC}Preferences.new
        if dlg.exec()
            # redo your settings
        end
    end
    
    def changeStatusbar(text)
        # display the text on the statusbar
        statusBar().message(text)
    end
    
    def changeCaption(text)
        # display the text on the caption
        setCaption(text)
    end

end
