/*
 *  Copyright (C) 2003 Ian Reinhart Geiser <geiseri@kde.org>
 */


#ifndef __KDEVPART_BASHSUPPORT_H__
#define __KDEVPART_BASHSUPPORT_H__


#include <tqguardedptr.h>

#include <tdeprocess.h>
#include <kdialogbase.h>

#include <codemodel.h>
#include <kdevplugin.h>
#include <kdevlanguagesupport.h>

#include <tdetexteditor/editinterface.h>
#include <tdetexteditor/viewcursorinterface.h>
#include <tdetexteditor/codecompletioninterface.h>

//class BashSupportWidget;

class BashCodeCompletion : TQObject
{
	TQ_OBJECT
  
	public:
		BashCodeCompletion();
		~BashCodeCompletion();
		void setActiveEditorPart(KParts::Part*);
		void setVars(TQStringList);
		TQValueList<KTextEditor::CompletionEntry> getVars(const TQString& textHint);

	public slots:
		void cursorPositionChanged();
		void completionBoxHidden();
		void completionBoxAbort();

	private:
		TQStringList m_vars;
		bool m_argWidgetShow;
		bool m_completionBoxShow;
		KTextEditor::EditInterface *m_editInterface;
		KTextEditor::CodeCompletionInterface *m_codeInterface;
		KTextEditor::ViewCursorInterface *m_cursorInterface;
};

class BashSupportPart : public KDevLanguageSupport
{
	TQ_OBJECT
  
	public:
		BashSupportPart(TQObject *parent, const char *name, const TQStringList &);
		virtual ~BashSupportPart();

	protected:
		virtual Features features();
		virtual KMimeType::List mimeTypes();

	private slots:
		void slotRun();
		void projectConfigWidget(KDialogBase *dlg);
		void projectOpened();
		void projectClosed();
		void savedFile(const KURL &fileName);
		void addedFilesToProject(const TQStringList &fileList);
		void removedFilesFromProject(const TQStringList &fileList);
		void parse();
		void slotActivePartChanged(KParts::Part *part);

	private:
		void startApplication(const TQString &program);
		TQString interpreter();
		void parse(const TQString &fileName);
		void addAttribute(const TQString &name, FileDom file, uint line);
		BashCodeCompletion *m_cc;
		TQStringList m_vars;

};

#endif
