/* This file is part of KCachegrind.
   Copyright (C) 2003 Josef Weidendorfer <Josef.Weidendorfer@gmx.de>

   KCachegrind is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

/*
 * Items of cost type view.
 */

#ifndef COSTTYEPITEM_H
#define COSTTYEPITEM_H

#include <tqlistview.h>
#include "tracedata.h"


class CostTypeItem: public TQListViewItem
{
public:
  CostTypeItem(TQListView* parent, TraceCostItem* costItem,
               TraceCostType* ct, TraceCost::CostType gt);

  int compare(TQListViewItem * i, int col, bool ascending ) const;
  void setGroupType(TraceCost::CostType);
  TraceCostItem* costItem() { return _costItem; }
  TraceCostType* costType() { return _costType; }
  void update();

private:
  SubCost _sum, _pure;
  TraceCostType* _costType;
  TraceCostItem* _costItem;
  TraceCost::CostType _groupType;
};


#endif
