/**************************************************************************
**                             parserbase.h
**                              -------------------
**      begin                   : Tue Jul 30 23:53:52 2002
**      copyright               : (C) 2002-2004 Otto Bruggeman
**      email                   : otto.bruggeman@home.nl
**
***************************************************************************/
/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   ( at your option ) any later version.
**
***************************************************************************/

#ifndef _DIFF2_PARSERBASE_H
#define _DIFF2_PARSERBASE_H

#include <tqregexp.h>

#include "kompare.h"
#include "difference.h"
#include "diffmodellist.h"

class TQStringList;
class TQString;

namespace Diff2
{

class KompareModelList;

class ParserBase
{
public:
	ParserBase( const KompareModelList* list, const TQStringList& diff );
	virtual ~ParserBase();

public:
	enum Kompare::Format format() { return determineFormat(); };
	DiffModelList* parse();

protected:
	virtual bool parseContextDiffHeader();
	virtual bool parseEdDiffHeader();
	virtual bool parseNormalDiffHeader();
	virtual bool parseRCSDiffHeader();
	virtual bool parseUnifiedDiffHeader();

	virtual bool parseContextHunkHeader();
	virtual bool parseEdHunkHeader();
	virtual bool parseNormalHunkHeader();
	virtual bool parseRCSHunkHeader();
	virtual bool parseUnifiedHunkHeader();

	virtual bool parseContextHunkBody();
	virtual bool parseEdHunkBody();
	virtual bool parseNormalHunkBody();
	virtual bool parseRCSHunkBody();
	virtual bool parseUnifiedHunkBody();

	virtual DiffModelList* parseContext();
	virtual DiffModelList* parseEd();
	virtual DiffModelList* parseNormal();
	virtual DiffModelList* parseRCS();
	virtual DiffModelList* parseUnified();

protected: // Helper methods to speed things up
	bool matchesUnifiedHunkLine( TQString line ) const;

protected:
	/** What is format of the diff */
	virtual enum Kompare::Format determineFormat();

protected:
	// Regexps for context parsing
	TQRegExp m_contextDiffHeader1;
	TQRegExp m_contextDiffHeader2;

	TQRegExp m_contextHunkHeader1;
	TQRegExp m_contextHunkHeader2;
	TQRegExp m_contextHunkHeader3;

	TQRegExp m_contextHunkBodyRemoved;
	TQRegExp m_contextHunkBodyAdded;
	TQRegExp m_contextHunkBodyChanged;
	TQRegExp m_contextHunkBodyContext;
	TQRegExp m_contextHunkBodyLine; // Added for convenience

	// Regexps for normal parsing
	TQRegExp m_normalDiffHeader;

	TQRegExp m_normalHunkHeaderAdded;
	TQRegExp m_normalHunkHeaderRemoved;
	TQRegExp m_normalHunkHeaderChanged;

	TQRegExp m_normalHunkBodyRemoved;
	TQRegExp m_normalHunkBodyAdded;
	TQRegExp m_normalHunkBodyDivider;

	enum Difference::Type m_normalDiffType;

	// RegExps for rcs parsing
	TQRegExp m_rcsDiffHeader;

	// Regexps for unified parsing
	TQRegExp m_unifiedDiffHeader1;
	TQRegExp m_unifiedDiffHeader2;

	TQRegExp m_unifiedHunkHeader;

	TQRegExp m_unifiedHunkBodyAdded;
	TQRegExp m_unifiedHunkBodyRemoved;
	TQRegExp m_unifiedHunkBodyContext;
	TQRegExp m_unifiedHunkBodyLine; // Added for convenience

protected:
	const TQStringList&         m_diffLines;
	DiffModel*                 m_currentModel;
	DiffModelList*             m_models;
	TQStringList::ConstIterator m_diffIterator;

	bool                       m_singleFileDiff;

protected:
	const KompareModelList* m_list;
};

} // End of namespace Diff2

#endif
