echo "Creating $LOCATION_ROOT/${APP_NAME_LC}/${APP_NAME_LC}view.cpp...";
cat << EOF > $LOCATION_ROOT/${APP_NAME_LC}/${APP_NAME_LC}view.cpp
#include "${APP_NAME_LC}view.h"

#include <tqpainter.h>
#include <tqlayout.h>

#include <kurl.h>

#include <ktrader.h>
#include <klibloader.h>
#include <tdemessagebox.h>
#include <krun.h>

${APP_NAME}View::${APP_NAME}View(TQWidget *parent)
    : TQWidget(parent),
      DCOPObject("${APP_NAME}Iface")
{
    // setup our layout manager to automatically add our widgets
    TQHBoxLayout *top_layout = new TQHBoxLayout(this);
    top_layout->setAutoAdd(true);

    // we want to look for all components that satisfy our needs.  the
    // trader will actually search through *all* registered KDE
    // applications and components -- not just KParts.  So we have to
    // specify two things: a service type and a constraint
    //
    // the service type is like a mime type.  we say that we want all
    // applications and components that can handle HTML -- 'text/html'
    // 
    // however, by itself, this will return such things as Netscape..
    // not what we wanted.  so we constrain it by saying that the
    // string 'KParts/ReadOnlyPart' must be found in the ServiceTypes
    // field.  with this, only components of the type we want will be
    // returned.
    TDETrader::OfferList offers = TDETrader::self()->query("text/html", "'KParts/ReadOnlyPart' in ServiceTypes");

    KLibFactory *factory = 0;
    // in theory, we only care about the first one.. but let's try all
    // offers just in case the first can't be loaded for some reason
    TDETrader::OfferList::Iterator it(offers.begin());
    for( ; it != offers.end(); ++it)
    {
        KService::Ptr ptr = (*it);

        // we now know that our offer can handle HTML and is a part.
        // since it is a part, it must also have a library... let's try to
        // load that now
        factory = KLibLoader::self()->factory( ptr->library() );
        if (factory)
        {
            m_html = static_cast<KParts::ReadOnlyPart *>(factory->create(this, ptr->name(), "KParts::ReadOnlyPart"));
            break;
        }
    }

    // if our factory is invalid, then we never found our component
    // and we might as well just exit now
    if (!factory)
    {
        KMessageBox::error(this, "Could not find a suitable HTML component");
        return;
    }

    connect(m_html, TQ_SIGNAL(setWindowCaption(const TQString&)),
            this,   TQ_SLOT(slotSetTitle(const TQString&)));
    connect(m_html, TQ_SIGNAL(setStatusBarText(const TQString&)),
            this,   TQ_SLOT(slotOnURL(const TQString&)));

}

${APP_NAME}View::~${APP_NAME}View()
{
}

void ${APP_NAME}View::print(TQPainter *p, int height, int width)
{
    // do the actual printing, here
    // p->drawText(etc..)
}

TQString ${APP_NAME}View::currentURL()
{
    return m_html->url().url();
}

void ${APP_NAME}View::openURL(TQString url)
{
    openURL(KURL(url));
}

void ${APP_NAME}View::openURL(const KURL& url)
{
    m_html->openURL(url);
}

void ${APP_NAME}View::slotOnURL(const TQString& url)
{
    emit signalChangeStatusbar(url);
}

void ${APP_NAME}View::slotSetTitle(const TQString& title)
{
    emit signalChangeCaption(title);
}
#include "${APP_NAME_LC}view.moc"
