/*
    Copyright (c) 2007 Volker Krause <vkrause@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef KMAIL_MESSAGEACTIONS_H
#define KMAIL_MESSAGEACTIONS_H

#include "kmcommands.h"
#include "kmreaderwin.h"

#include <tqobject.h>
#include <tqvaluelist.h>

class TQWidget;
class TDEAction;
class TDEActionMenu;
class TDEActionCollection;
class KMMessage;

namespace KMail {

/**
  Manages common actions that can be performed on one or more messages.
*/
class MessageActions : public TQObject
{
  TQ_OBJECT
  
  public:
    MessageActions( TDEActionCollection* ac, TQWidget *parent );
    void setMessageView( KMReaderWin *msgView );

    void setCurrentMessage( KMMessage *msg );
    void setSelectedSernums( const TQValueList<TQ_UINT32> &sernums );
    void setSelectedVisibleSernums( const TQValueList<TQ_UINT32> &sernums );

    TDEActionMenu* replyMenu() const { return mReplyActionMenu; }
    TDEAction* replyListAction() const { return mReplyListAction; }
    TDEAction* createTodoAction() const { return mCreateTodoAction; }

    TDEActionMenu* messageStatusMenu() const { return mStatusMenu; }

    TDEAction* editAction() const { return mEditAction; }

  signals:

    // This signal is emitted when a reply is triggered and the
    // action has finished.
    // This is useful for the stand-alone reader, it might want to close the window in
    // that case.
    void replyActionFinished();

  public slots:
    void editCurrentMessage();

  private:
    void updateActions();
    template<typename T> void replyCommand();
    void setMessageStatus( KMMsgStatus status, bool toggle = false );

  private slots:
    void slotReplyToMsg();
    void slotReplyAuthorToMsg();
    void slotReplyListToMsg();
    void slotReplyAllToMsg();
    void slotNoQuoteReplyToMsg();
    void slotCreateTodo();
    void slotSetMsgStatusNew();
    void slotSetMsgStatusUnread();
    void slotSetMsgStatusRead();
    void slotSetMsgStatusTodo();
    void slotSetMsgStatusFlag();

  private:
    TQWidget *mParent;
    TDEActionCollection *mActionCollection;
    KMMessage* mCurrentMessage;
    TQValueList<TQ_UINT32> mSelectedSernums;
    TQValueList<TQ_UINT32> mVisibleSernums;
    KMReaderWin *mMessageView;

    TDEActionMenu *mReplyActionMenu;
    TDEAction *mReplyAction, *mReplyAllAction, *mReplyAuthorAction,
            *mReplyListAction, *mNoQuoteReplyAction;
    TDEAction *mCreateTodoAction;
    TDEActionMenu *mStatusMenu;
    TDEToggleAction *mToggleFlagAction, *mToggleTodoAction;
    TDEAction *mEditAction;
};

}

#endif

