/*
    refreshkeysjob.h

    This file is part of libkleopatra, the KDE keymanagement library
    Copyright (c) 2004 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef __KLEO_REFRESHKEYSJOB_H__
#define __KLEO_REFRESHKEYSJOB_H__

#include "job.h"

#include <vector>

namespace GpgME {
  class Error;
  class Key;
}

class TQStringList;

namespace Kleo {

  /**
     @short An abstract base class for asynchronous key refreshers.

     To use a RefreshKeysJob, first obtain an instance from the
     CryptoBackend implementation, connect the progress() and result()
     signals to suitable slots and then start the key refresh with a
     call to start(). This call might fail, in which case the
     RefreshKeysJob instance will have scheduled its own destruction
     with a call to TQObject::deleteLater().

     After result() is emitted, the KeyListJob will schedule it's own
     destruction by calling TQObject::deleteLater().
  */
  class RefreshKeysJob : public Job {
    TQ_OBJECT
  
  protected:
    RefreshKeysJob( TQObject * parent, const char * name );

  public:
   ~RefreshKeysJob();

     /**
       Starts the keylist operation. \a pattern is a list of patterns
       used to restrict the list of keys returned. Empty patterns are
       ignored. If \a pattern is empty or contains only empty strings,
       all keys are returned (however, the backend is free to truncate
       the result and should do so; when this happens, it will be
       reported by the reult object).

       If \a secretOnly is true, only keys for which the secret key is
       also available are returned. Use this if you need to select a
       key for signing.
    */
    virtual GpgME::Error start( const TQStringList & patterns ) = 0;

  signals:
    void result( const GpgME::Error & error );
  };

}

#endif // __KLEO_REFRESHKEYSJOB_H__
