/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "sloxaccounts.h"

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdecmdlineargs.h>

#include <tqpushbutton.h>

static const TDECmdLineOptions options[] =
{
  {"verbose", "Verbose output", 0},
  TDECmdLineLastOption
};

int main(int argc,char **argv)
{
  TDEAboutData aboutData( "textsloxaccounts",
                        "SUSE LINUX Openexchange Server Configuration Wizard",
                        "0.1" );
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );

  TDEApplication app;

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  bool verbose = false;
  if ( args->isSet( "verbose" ) ) verbose = true;

  TQPushButton button( "Close", 0 );

  SloxAccounts::setServer( "f85.suse.de" );
  SloxAccounts::self();
  
  app.setMainWidget( &button );
  button.show();
  TQObject::connect( &button, TQ_SIGNAL( clicked() ), &app, TQ_SLOT( quit() ) );
  
  app.exec();
}
