 /*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2004 Till Adam <adam@kde.org>
    Copyright (c) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KABC_GROUPDAVADDRESSBOOKADAPTOR_H
#define KABC_GROUPDAVADDRESSBOOKADAPTOR_H

#include "davaddressbookadaptor.h"
#include "groupdavglobals.h"
#include <davgroupwareglobals.h>
#include <tdeabc/addressee.h>
#include <kurl.h>

#include <tqdom.h>

namespace TDEABC {

class GroupDavAddressBookAdaptor : public DavAddressBookAdaptor
{
  public:
    GroupDavAddressBookAdaptor();

    void customAdaptDownloadUrl( KURL &url );
    void customAdaptUploadUrl( KURL &url );
    TQString mimeType() const { return "text/x-vcard"; }
    TQCString identifier() const { return "KABCResourceGroupDAV"; }
    TQString defaultNewItemName( KPIM::GroupwareUploadItem */*item*/ ) { return "new.vcf"; }
    long flags() const { return 0; }


    // Creating Jobs
    TDEIO::Job *createListFoldersJob( const KURL &url )
        { return GroupDavGlobals::createListFoldersJob( url ); }
    TDEIO::TransferJob *createListItemsJob( const KURL &url )
        { return GroupDavGlobals::createListItemsJob( url ); }
    TDEIO::TransferJob *createDownloadJob( const KURL &url, KPIM::FolderLister::ContentType ctype )
        { return GroupDavGlobals::createDownloadJob( this, url, ctype ); }
    TDEIO::Job *createRemoveJob( const KURL &uploadurl, KPIM::GroupwareUploadItem *deletedItem )
        { return GroupDavGlobals::createRemoveJob( this, uploadurl, deletedItem ); }


    // Interpreting Jobs
    bool interpretListItemsJob( TDEIO::Job *job, const TQString &/*jobData*/ )
        { return GroupDavGlobals::interpretListItemsJob( this, job ); }
    bool interpretDownloadItemsJob( TDEIO::Job *job, const TQString &jobData )
        { return GroupDavGlobals::interpretAddressBookDownloadItemsJob(
           this, job, jobData ); }


    bool getFolderHasSubs( const TQDomNode &folderNode )
        { return GroupDavGlobals::getFolderHasSubs( folderNode ); }
    KPIM::FolderLister::ContentType getContentType( const TQDomNode &folderNode )
        { return GroupDavGlobals::getContentType( folderNode ); }
};

}




#endif
