/*
 * Copyright (C) 2004, Mart Kelder (mart.kde@hccnet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MK_TDEIO_SINGEL_SUBJECT_H
#define MK_TDEIO_SINGEL_SUBJECT_H

//This function reads a single subject

#include <tqobject.h>
#include <tqcstring.h>

class KornMailSubject;

class KURL;
namespace TDEIO { class MetaData; class Job; class TransferJob; class Slave; }
class TDEIO_Protocol;

class TQString;

class TDEIO_Single_Subject : public TQObject
{ TQ_OBJECT
  
public:
	TDEIO_Single_Subject( TQObject * parent, const char * name, KURL &, TDEIO::MetaData &, const TDEIO_Protocol *,
	                    TDEIO::Slave *&, const TQString &, const long );
	~TDEIO_Single_Subject( );
	
	//This functions try's te parse EMail; data, sender names and so on...
	static void parseMail( TQString * message, KornMailSubject *subject, bool );
	
private:
	TQString *_message;
	TQString *_name;
	KURL *_kurl;
	const TDEIO_Protocol *_protocol;
	TDEIO::MetaData *_metadata;
	TDEIO::TransferJob* _job;
	long _size;
	
	void init( TDEIO::Slave*& );
	
private slots:
	void slotResult( TDEIO::Job* );
	void slotData( TDEIO::Job*, const TQByteArray& );
	
signals:
	//This signal is emitted if the headers are read and put into a KornMailSubject*
	void readSubject( KornMailSubject* );
	//This signal is emitted if this class could be destroyed.
	void finished( TDEIO_Single_Subject* );
};

#endif
