/*
    This file is part of KOrganizer.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqpainter.h>

#include <kdebug.h>

#include "timeline.h"
#include "timeline.moc"

TimeLine::TimeLine( TQWidget *parent, const char *name ) :
  TQScrollView( parent, name )
{
  mPixelWidth = 1000;
  
  resizeContents( mPixelWidth, 20 );

  viewport()->setBackgroundMode( PaletteBackground );

  setHScrollBarMode(AlwaysOff);
  setVScrollBarMode(AlwaysOff);
}

TimeLine::~TimeLine()
{
}

void TimeLine::drawContents(TQPainter* p, int cx, int cy, int cw, int ch)
{
  int spacingX = mDaySpacing;
  int offsetX = mDayOffset;

  // Draw vertical lines of grid
//  kdDebug(5850) << "drawContents cx: " << cx << " cy: " << cy << " cw: " << cw << " ch: " << ch << endl;
  int cell = int( (cx - ( spacingX - offsetX ) ) / spacingX );
  int x = cell * spacingX + ( spacingX - offsetX );
//  kdDebug(5850) << "  x: " << x << endl;
  while (x < cx + cw) {
//    kdDebug(5850) << "    x: " << x << endl;
    p->drawLine(x,cy,x,cy+ch);
    p->drawText( x + 5, 15, TQString::number( mStartDate.addDays( cell + 1 ).date().day() ) );

    x += spacingX;
    cell++;
  }
}

void TimeLine::setDateRange( const TQDateTime &start, const TQDateTime &end )
{
  mStartDate = start;
  mEndDate = end;
  
  mSecsPerPixel = mStartDate.secsTo( mEndDate ) / mPixelWidth;
  
  mDaySpacing = 60 * 60 * 24 / mSecsPerPixel;

  mDayOffset = TQDateTime( mStartDate.date() ).secsTo( mStartDate ) / mSecsPerPixel;

  kdDebug(5850) << "TimeLines::setDateRange(): mDaySpacing: " << mDaySpacing << "  mDayOffset: "
            << mDayOffset << "  mSecsPerPixel: " << mSecsPerPixel << endl;
}

void TimeLine::setContentsPos( int pos )
{
  TQScrollView::setContentsPos ( pos, 0 );
}
