/*
    knode.cpp

    KNode, the KDE newsreader
    Copyright (c) 1999-2004 the KNode authors.
    See file AUTHORS for details

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, US
*/
#include "knode.h"
#include "knglobals.h"
#include "knwidgets.h"

#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kstdaction.h>
#include <kdebug.h>
#include <tdemenubar.h>
#include <kiconloader.h>
#include <kstatusbar.h>
#include <tdelocale.h>
#include <tdeapplication.h>

#include "broadcaststatus.h"
#include "krsqueezedtextlabel.h"
#include "progressdialog.h"
#include "statusbarprogresswidget.h"

//GUI
#include "knmainwidget.h"
#include "knarticlewindow.h"
#include "kncollectionviewitem.h"
#include "knhdrviewitem.h"

KNMainWindow::KNMainWindow( TQWidget* pWidget )
  : TDEMainWindow(pWidget,"mainWindow")
{
  //setupStatusBar();
  createStandardStatusBarAction();
  setStandardToolBarMenuEnabled(true);

  //config stuff
  KStdAction::quit(tdeApp, TQ_SLOT(closeAllWindows()), actionCollection());
  KStdAction::configureToolbars(this, TQ_SLOT(slotConfToolbar()), actionCollection());
  KStdAction::keyBindings(this, TQ_SLOT(slotConfKeys()), actionCollection());

  m_mainWidget = new KNMainWidget( this, true, this, 0 );
  connect( m_mainWidget, TQ_SIGNAL(signalCaptionChangeRequest(const TQString&)),
           TQ_SLOT( setCaption(const TQString&)) );
  setCentralWidget( m_mainWidget );
  setupStatusBar();
  connect( KPIM::BroadcastStatus::instance(), TQ_SIGNAL(statusMsg(const TQString&)),
    this, TQ_SLOT(slotShowStatusMsg(const TQString& )) );
  createGUI( "knodeui.rc" );
  knGlobals.instance = 0;

  applyMainWindowSettings(TDEGlobal::config(),"mainWindow_options");
}

KNMainWindow::~KNMainWindow()
{
  saveMainWindowSettings(knGlobals.config(),"mainWindow_options");
}

void KNMainWindow::openURL( const KURL& url )
{
  m_mainWidget->openURL( url );
}

void KNMainWindow::slotConfToolbar()
{
  saveMainWindowSettings(knGlobals.config(),"mainWindow_options");
  KEditToolbar dlg(actionCollection(), "knodeui.rc");
  connect(&dlg,TQ_SIGNAL( newToolbarConfig() ), this, TQ_SLOT( slotNewToolbarConfig() ));
  dlg.exec();
}

void KNMainWindow::slotNewToolbarConfig()
{
  createGUI("knodeui.rc");
  //initPopups();
  applyMainWindowSettings(knGlobals.config(),"mainWindow_options");
}

void KNMainWindow::slotConfKeys()
{
  KKeyDialog::configure(actionCollection(), true);
}

bool KNMainWindow::queryClose()
{
  return m_mainWidget->queryClose();
}

void KNMainWindow::setupStatusBar()
{
  mProgressDialog = new KPIM::ProgressDialog( statusBar(), this );
  mProgressDialog->hide();

  mLittleProgress = new StatusbarProgressWidget( mProgressDialog, statusBar() );
  mLittleProgress->show();

  statusBar()->addWidget( mLittleProgress, 0 , true );

  mStatusMsgLabel = new KRSqueezedTextLabel( TQString(), statusBar() );
  mStatusMsgLabel->setAlignment( AlignLeft | AlignVCenter );
  statusBar()->addWidget( mStatusMsgLabel, 2 );
  statusBar()->addWidget(m_mainWidget->statusBarLabelFilter(), 2);
  statusBar()->addWidget(m_mainWidget->statusBarLabelGroup(), 3);
}

void KNMainWindow::slotShowStatusMsg( const TQString &msg ) {
  mStatusMsgLabel->setText( msg );
}

#include "knode.moc"
