/*
    customactions.cpp

    This file is part of Kleopatra, the KDE keymanager
    Copyright (c) 2001,2002,2004 Klarlvdalens Datakonsult AB

    Kleopatra is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Kleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#include "customactions.h"

#include <tdetoolbar.h>
#include <tdeapplication.h>

#include <tqlineedit.h>
#include <tqlabel.h>


LabelAction::LabelAction( const TQString & text,  TDEActionCollection * parent,
			  const char* name )
  : TDEAction( text, TQIconSet(), TDEShortcut(), 0, 0, parent, name )
{

}

int LabelAction::plug( TQWidget * widget, int index ) {
  if ( tdeApp && !tdeApp->authorizeTDEAction( name() ) )
    return -1;
  if ( widget->inherits( "TDEToolBar" ) ) {
    TDEToolBar * bar = (TDEToolBar *)widget;
    int id_ = getToolButtonID();
    TQLabel* label = new TQLabel( text(), bar, "tde toolbar widget" );
    bar->insertWidget( id_, label->width(), label, index );
    addContainer( bar, id_ );
    connect( bar, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( slotDestroyed() ) );
    return containerCount() - 1;
  }

  return TDEAction::plug( widget, index );
}

LineEditAction::LineEditAction( const TQString & text, TDEActionCollection * parent,
				TQObject * receiver, const char * member, const char * name )
  : TDEAction( text, TQIconSet(), TDEShortcut(), 0, 0, parent, name ),
    _le(0), _receiver(receiver), _member(member)
{

}

int LineEditAction::plug( TQWidget * widget, int index ) {
  if ( tdeApp && !tdeApp->authorizeTDEAction( name() ) )
    return -1;
  if ( widget->inherits( "TDEToolBar" ) ) {
    TDEToolBar *bar = (TDEToolBar *)widget;
    int id_ = getToolButtonID();
    // The toolbar trick doesn't seem to work for lineedits
    //_le = new TQLineEdit( bar, "tde toolbar widget" );
    _le = new TQLineEdit( bar );
    bar->insertWidget( id_, _le->width(), _le, index );
    bar->setStretchableWidget( _le );
    addContainer( bar, id_ );
    connect( bar, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( slotDestroyed() ) );
    connect( _le, TQ_SIGNAL( returnPressed() ), _receiver, _member );
    return containerCount() - 1;
  }

  return TDEAction::plug( widget, index );
}

void LineEditAction::clear() {
  _le->clear();
}

void LineEditAction::focusAll() {
  _le->selectAll();
  _le->setFocus();
}

TQString LineEditAction::text() const {
  return _le->text();
}

void LineEditAction::setText( const TQString & txt ) {
  _le->setText(txt);
}


ComboAction::ComboAction( const TQStringList & lst,  TDEActionCollection * parent,
			  TQObject * receiver, const char * member, const char * name,
                          int selectedID )
  : TDEAction( TQString(), TQIconSet(), TDEShortcut(), 0, 0, parent, name ),
    _lst(lst), _receiver(receiver), _member(member), _selectedId( selectedID )
{

}

int ComboAction::plug( TQWidget * widget, int index ) {
  if ( tdeApp && !tdeApp->authorizeTDEAction( name() ) )
    return -1;
  if ( widget->inherits( "TDEToolBar" ) ) {
    TDEToolBar *bar = (TDEToolBar *)widget;
    int id_ = getToolButtonID();
    bar->insertCombo( _lst, id_, false, TQ_SIGNAL( highlighted(int) ), _receiver, _member );
    bar->setCurrentComboItem( id_,_selectedId );
    addContainer( bar, id_ );
    connect( bar, TQ_SIGNAL( destroyed() ), this, TQ_SLOT( slotDestroyed() ) );
    return containerCount() - 1;
  }

  return TDEAction::plug( widget, index );
}

#include "customactions.moc"
