/***************************************************************************
 *
 * tdenetman-vpnmanager.cpp - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *         Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <tdelocale.h>
#include <tqdir.h>
#include <kdebug.h>
#include <tdeconfig.h>

#include "tdenetman-vpnmanager.h"
#include "tdenetman-vpnservice.h"
#include "tdenetman-vpnplugin.h"

/*
 *  class VPNManager
 *
 */
VPNServiceList
VPNManager::getVPNServices ()
{
	VPNServiceList list;

	TDEGlobalNetworkManager* nm = TDEGlobal::networkManager();

	if (nm)
	{
		TDENetworkVPNTypeList availablePlugins = nm->availableVPNTypes();

		if (availablePlugins.count() > 0)
		{
			// find all available services
			for (TDENetworkVPNTypeList::Iterator it = availablePlugins.begin (); it != availablePlugins.end (); ++it)
			{
				TQString serviceString;
				if ((*it) == TDENetworkVPNType::OpenVPN)
				{
					serviceString = "openvpn";
				}
				else if ((*it) == TDENetworkVPNType::PPTP)
				{
					serviceString = "pptp";
				}
				else if ((*it) == TDENetworkVPNType::StrongSwan)
				{
					serviceString = "strongswan";
				}
				else if ((*it) == TDENetworkVPNType::VPNC)
				{
					serviceString = "vpnc";
				}
				if (serviceString == "")
				{
					continue;
				}

				kdDebug() << "VPN Service " << serviceString.ascii() << endl;

				// create new VPNService Object
				VPNService* vpnservice = new VPNService(serviceString, serviceString, TDENetworkManager::getInstance());
				if (!vpnservice->getVPNPlugin())
				{
					delete vpnservice;
				}
				else
				{
					list.push_back(vpnservice);
				}
			}
		}
	}

	return list;
}

VPNService*
VPNManager::getVPNService(TQString service_type)
{
	VPNServiceList list;

	TDEGlobalNetworkManager* nm = TDEGlobal::networkManager();
	if (nm)
	{
		TDENetworkVPNTypeList availablePlugins = nm->availableVPNTypes();

		if (availablePlugins.count() > 0)
		{
			for (TDENetworkVPNTypeList::Iterator it = availablePlugins.begin (); it != availablePlugins.end (); ++it)
			{
				TQString serviceString;
				if ((*it) == TDENetworkVPNType::OpenVPN)
				{
					serviceString = "openvpn";
				}
				else if ((*it) == TDENetworkVPNType::PPTP)
				{
					serviceString = "pptp";
				}
				else if ((*it) == TDENetworkVPNType::StrongSwan)
				{
					serviceString = "strongswan";
				}
				else if ((*it) == TDENetworkVPNType::VPNC)
				{
					serviceString = "vpnc";
				}
				if (serviceString == "")
				{
					continue;
				}

				if (serviceString == service_type)
				{
					// create new VPNService Object
					VPNService* vpnservice = new VPNService(service_type, service_type, TDENetworkManager::getInstance());
					if (!vpnservice->getVPNPlugin())
					{
						delete vpnservice;
					}
					else
					{
						return vpnservice;
					}
				}
			}
		}
	}

	return NULL;
}

#include "tdenetman-vpnmanager.moc"
