/*
Copyright (C) 2012 Timothy Pearson <kb9vqf@pearsoncomputing.net>
Copyright 2008 Will Stephenson <wstephenson@kde.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License or (at your option) version 3 or any later version
accepted by the membership of KDE e.V. (or its successor approved
by the membership of KDE e.V.), which shall act as a proxy 
defined in Section 14 of version 3 of the license.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DEVICE_TRAY_COMPONENT_H
#define DEVICE_TRAY_COMPONENT_H

#include <tqmap.h>
#include <tqmovie.h>
#include <tqobject.h>
#include <tqpixmap.h>

#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

#include "tdenetman-tray.h"
#include "traycomponent.h"

class TDENetworkDevice;
class TDEPopupMenu;
class KSystemTray;

class DeviceTrayComponent : public TrayComponent
{
	TQ_OBJECT
	
	public:
		DeviceTrayComponent(TQString device, KSystemTray * parent, const char * name );
		virtual ~DeviceTrayComponent();
		TQPixmap pixmapForState(TDENetworkConnectionStatus::TDENetworkConnectionStatus state);
		TQMovie movieForState(TDENetworkConnectionStatus::TDENetworkConnectionStatus state);
		virtual TQStringList getToolTipText();
		TQString device() const;

	signals:
		void needsCenterStage(TrayComponent *, bool);

	public slots:
		virtual void newConnection() = 0;

	protected slots:
		void deviceStateChanged(TDENetworkConnectionStatus::TDENetworkConnectionStatus, TDENetworkConnectionStatus::TDENetworkConnectionStatus, TQString);

	private slots:
		void deviceEventHandler(TDENetworkDeviceEventType::TDENetworkDeviceEventType event, TQString message);

	protected:
		void setMovieForState(TDENetworkConnectionStatus::TDENetworkConnectionStatus, TQString);
		void setPixmapForState(TDENetworkConnectionStatus::TDENetworkConnectionStatus, TQString);

	private:
		TQString pixmapForConnState(TDENetworkConnectionStatus::TDENetworkConnectionStatus state);
		TQString movieForConnState(TDENetworkConnectionStatus::TDENetworkConnectionStatus state);
		TQString tooltipForConnState(TDENetworkConnectionStatus::TDENetworkConnectionStatus state);

	public:
		TDENetworkConnectionStatus::TDENetworkConnectionStatus lastKnownState;

	protected:
		Tray* m_tray;

	private slots:
		void sendGetCenterStage();
		void sendReleaseCenterStage();

	private:
		TQString m_device;
		TQMap<TDENetworkConnectionStatus::TDENetworkConnectionStatus, TQString> m_movies;
		TQMap<TDENetworkConnectionStatus::TDENetworkConnectionStatus, TQString> m_pixmaps;
		TQMap<TDENetworkConnectionStatus::TDENetworkConnectionStatus, TQString> m_tooltips;
};
#endif // DEVICE_TRAY_COMPONENT_H
