#ifndef TAGSGET_H
#define TAGSGET_H

#include <tqobject.h>
#include <cmodule.h>
#include <tqvaluelist.h>
#include <tqptrlist.h>
#include "tags.h"

class TagsGetter : public TQObject, public PlaylistNotifier
{
TQ_OBJECT
  
public:
	TagsGetter();
	void associate(Tags *t);
	// if returns true, I'm deleted
	bool unassociate(Tags *t);

	int interval() const;
	bool loadAuto() const;

public: //playlistnotifier
	virtual void added(PlaylistItem &);
	virtual void removed(PlaylistItem &);

protected:
	void timerEvent(TQTimerEvent *);
	
private slots:
	// select the songs that need updating
	void getSongs();

	void newSong();

public slots:
	void setInterval(int ms);
	void setLoadAuto(bool);

private:
	void sortPriority();

private:
	TQPtrList<Tags> tags;
	TQValueList<PlaylistItem> items;
};

class Control : public CModule
{
TQ_OBJECT
  
public:
	Control(TagsGetter* parent);
};


#endif

