#include "main.h"
#include "main.moc"

#include <tdelocale.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <kkeydialog.h>
#include <tdeconfigdialog.h>

#include "inter.h"
#include "factory.h"

void MainWindow::addConfig(TDEConfigDialog *dialog)
{
    TQWidget *w = cfactory->createAIConfig();
    if (w) dialog->addPage(w, i18n("A.I."), "preferences-desktop-personal");
}

void MainWindow::init()
{
    Interface *inter = static_cast<Interface *>(_inter);
    inter->normalGame();
    setFocusPolicy(TQWidget::StrongFocus);
    
    // Modes
    bool ama = ( bfactory->bbi.nbArcadeStages!=0 );
    TQString s = (ama ? i18n("&Single Human (Normal)") : i18n("&Single Human"));
    (void)new TDEAction(s, 0, inter, TQ_SLOT(normalGame()),
                      actionCollection(), "mp_single_human");
    if (ama) (void)new TDEAction(i18n("&Single Human (Arcade)"), 0,
                               inter, TQ_SLOT(arcadeGame()),
                               actionCollection(), "mp_arcade");
    (void)new TDEAction(i18n("Human vs &Human"), 0, inter, TQ_SLOT(humanVsHuman()),
                      actionCollection(), "mp_human_vs_human");
    (void)new TDEAction(i18n("Human vs &Computer"), 0,
                      inter, TQ_SLOT(humanVsComputer()),
                      actionCollection(), "mp_human_vs_computer");
    (void)new TDEAction(i18n("&More..."), 0, inter, TQ_SLOT(dialog()),
                      actionCollection(), "mp_more");

    buildGUI(inter);
    connect(this, TQ_SIGNAL(settingsChanged()),
            inter, TQ_SLOT(settingsChangedSlot()));
}

void MainWindow::addKeys(KKeyDialog &d)
{
    static_cast<Interface *>(_inter)->addKeys(d);
}

void MainWindow::saveKeys()
{
    static_cast<Interface *>(_inter)->saveKeys();
}

void MainWindow::focusInEvent(TQFocusEvent *e)
{
    static_cast<Interface *>(_inter)->setFocus();
    BaseMainWindow::focusInEvent(e);
}
