#ifndef _BACKGROUND_H
#define _BACKGROUND_H
#include <tqstring.h>

class TQPixmap;
class TQImage;


class Background  
{


  public:
    Background();
    ~Background();
    bool tile;
    
    bool load(const TQString &file, short width, short height);
    void sizeChanged(int newW, int newH);
    void scaleModeChanged();
    TQPixmap *getBackground() {return backgroundPixmap;}
    TQPixmap *getShadowBackground() {return backgroundShadowPixmap;}
 private:
    void sourceToBackground();

    int tileMode;    // scale background = 0, tile = 1
    TQImage *backgroundImage;
    TQImage *sourceImage;
    TQPixmap *backgroundPixmap;
    TQPixmap *backgroundShadowPixmap;
    TQString filename;
    short w;
    short h;
};

#endif
